#ifndef MMCTHREASHOLDCALC_H
#define MMCTHREASHOLDCALC_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcThresholdCalc                                                        //
//                                                                         //
// Compute the energy threshold from Monte Carlo data                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_h
#include "MTask.h"
#endif

class MMcEvt;
class MMcTrig;
class MHMcEnergy;

class MMcThresholdCalc : public MTask
{
private:
    UInt_t fDimension;

    const MMcEvt  *fMcEvt;       // Container with Monte Carlo information
    MMcTrig      **fMcTrig;      // Container with Monte Carlo trigger information
    MHMcEnergy   **fHMcEnergy;   // Container where we save the energy (threshold)

    Bool_t        *fMustDelete;  // delete indicator for selfcreated energy hists

    const static Float_t fSqrt2; // sqrt(2)

public:

    MMcThresholdCalc(const UInt_t dim = 1,
                     const char* name = NULL, const char* title = NULL);
    ~MMcThresholdCalc();

    Bool_t PreProcess(MParList* pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MMcThresholdCalc, 0) // Task to compute the energy threshold
};

#endif



