/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lopez 05/2001 (jlopez@ifae.es)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
//  MHMcEnergies
//
// This class holds and array of MHMcEnergy objects in order to be able
// to compute the threshold for each of the different trigger conditions
// in a root file.
//
////////////////////////////////////////////////////////////////////////////
#include "MHMcEnergies.h" 

#include "MParList.h"
#include "MHMcEnergy.h"

ClassImp(MHMcEnergies);

// --------------------------------------------------------------------------
//
// Default Constructor.
//
MHMcEnergies::MHMcEnergies(const UInt_t count, const char *name, const char *title)
    : fNum(count)
{ 
    char aux[25]="MHMcEnergies";
    sprintf(aux+12, "[%i]", fNum);

    *fName  = name  ? name  : aux;
    *fTitle = title ? title : "Container for a MC enegry histogram" ;

    fHists = new TClonesArray("MHMcEnergy", fNum);

    for (UInt_t i=0; i<fNum; i++)
        new ((*fHists)[i]) MHMcEnergy(i);
}

// --------------------------------------------------------------------------
//
// Default Destructor.
//
MHMcEnergies::~MHMcEnergies()
{
    delete fHists;
}

// --------------------------------------------------------------------------
//
// Add to the parameter list all the MHMcEnergy objects contained in the array.
//
void MHMcEnergies::AddEntriesToList(MParList *plist)
{
    for (UInt_t i=0; i<fNum; i++)
        plist->AddToList((MParContainer*)(*fHists)[i]);
}
