#ifndef MARS_MHn
#define MARS_MHn

#ifndef ROOT_TH1
#include <TH1.h>
#endif
#ifndef MARS_MH
#include "MH.h"
#endif

class MH3;

class MHn : public MH
{
public:
    enum Layout_t { kSimple, kComplex };

protected:
    MH3    *fHist[6];        // Possible six histograms
    TString fDrawOption[6];  // Possible corresponding draw options

    Layout_t fLayout;        // Specifier for the layout in the canvas

    Int_t fNum;              // Number of initialized histograms

    void InitHist();

    Bool_t InitName(Int_t n,  const char *n);
    Bool_t InitTitle(Int_t n, const char *t);
    Bool_t SetDrawOption(Int_t n, const char *opt);

public:
    MHn(const char *name=NULL, const char *title=NULL);
    ~MHn();

    // Setter
    void SetLayout(Layout_t t) { fLayout = t; }

    Bool_t AddHist(const char *memberx);
    Bool_t AddHist(const char *memberx, const char *membery);
    Bool_t AddHist(const char *memberx, const char *membery, const char *memberz);

    void SetDrawOption(const char *opt) { SetDrawOption(fNum-1, opt); }

    void InitName(const char *n)
    {
        InitName(fNum-1, n);
    }

    void InitTitle(const char *t)
    {
        InitTitle(fNum-1, t);
    }

    /*
    void SetScaleX(Double_t scale) { fScale[0] = scale; }
    void SetScaleY(Double_t scale) { fScale[1] = scale; }
    void SetScaleZ(Double_t scale) { fScale[2] = scale; }

    void SetLogx(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogx) : fHist->ResetBit(kIsLogx); }
    void SetLogy(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogy) : fHist->ResetBit(kIsLogy); }
    void SetLogz(Bool_t b=kTRUE) { b ? fHist->SetBit(kIsLogz) : fHist->ResetBit(kIsLogz); }

    void Sumw2() const { if (fHist) fHist->Sumw2(); }
    */

    // MH
    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    // TObject
    //void SetColors() const;
    void Draw(Option_t *opt=NULL);
    //void Paint(Option_t *opt="");

    ClassDef(MHn, 1) // Generalized histogram class for up to six histograms
};

#endif
