#ifndef MHMCRATE_H
#define MHMCRATE_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#define PI_NUMBER 3.1415926

class MHMcRate : public MParContainer { 

 private: 
  UShort_t fPartId;         // Type of particle

  Float_t fEnergyMax;       // Maximum Energy in GeV
  Float_t fEnergyMin;       // Minimum Energy in GeV

  Float_t fThetaMax;        // Maximum theta angle of run 
  Float_t fThetaMin;        // Minimum theta angle of run
  Float_t fPhiMax;          // Maximum phi angle of run 
  Float_t fPhiMin;          // Minimum phi angle of run

  Float_t fImpactMax;       // Maximum impact parameter
  Float_t fImpactMin;       // Minimum impact parameter
 
  Float_t fBackTrig;        // Number of triggers from background
  Float_t fBackSim;         // Number of simulated showers for the background

  Float_t fSpecIndex;       // dn/dE = k * e^{- fSpecIndex}
  Float_t fFlux0;           // dn/dE = fFlux0 * E^{-a}

  Float_t fShowRate;        // Showers rate in Hz
  Float_t fShowRateError;   // Estimated error of shower rate in Hz

  Float_t fTrigRate;        // Trigger rate in Hz
  Float_t fTrigRateError;   // Estimated error for the trigger rate in Hz

 public: 
  
  MHMcRate(const char *name=NULL, const char *title=NULL) ; 
  MHMcRate(Float_t ShowRate,
	  const char *name=NULL, const char *title=NULL) ; 
  MHMcRate(Float_t SpecIndex, Float_t Flux0, 
	  const char *name=NULL, const char *title=NULL) ; 
  ~MHMcRate() ; 

  void SetParticle(UShort_t part);
  void SetBackground (Float_t Showers, Float_t Triggers);

  void Boundaries(Float_t Energy, Float_t Theta, Float_t Phi, Float_t Impact);

  void CalcRate(Float_t trig, Float_t anal, Float_t simu);

  void Print();
  void Draw(const Option_t *);

  ClassDef(MHMcRate, 1)  //  Data Container to calculate Collection Area
} ; 

#endif 
