#ifndef MTRIGGERRATECALC_H
#define MTRIGGERRATECALC_H

#ifndef MTASK_H
#include "MTask.h"
#endif

#include "MMcEvt.hxx"

class MParList;
class MMcTrig ; 
class MMcEvt;
class MHMcRate;

class MMcTriggerRateCalc : public MTask {
 private:
  MMcTrig         *fMcTrig[10]  ; //!
  MMcEvt          *fMcEvt;        //!

  MHMcRate         *fMcRate[10] ;  //!

  Int_t           fDimension;     // Information about the trigger conditions
                                  // in the root file to be read.

  Float_t         fTrigger[10];   // Number of triggered showers
  Float_t         fShowers;       // Number of simulated showers
  Float_t         fAnalShow;      // Number of analysed showers

  Int_t           fPartId;        // Incident particle that generates showers

  Float_t         fSpecInd;       // Spectral indec of the simualtion
  Float_t         fFlux0;         // Flux 0 for the differential flux

 public:   
  MMcTriggerRateCalc (const char *name=NULL, const char *title=NULL); 
  MMcTriggerRateCalc (int dim, int part, float *trigbg, float simbg, float rate,
		  const char *name=NULL, const char *title=NULL);
  MMcTriggerRateCalc (int dim, int part, float *trigbg, float simbg, float spec,
		  float flux0, const char *name=NULL, const char *title=NULL);

  Bool_t PreProcess(MParList *pList);
  Bool_t Process() ;
  Bool_t PostProcess() ;
  
  ClassDef(MMcTriggerRateCalc, 0)	// Task to compute the trigger rate

};

#endif 
