#ifndef MARS_MTriggerPattern
#define MARS_MTriggerPattern

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MTriggerPattern : public MParContainer
{
    friend class MTriggerPatternDecode;

public:
    enum Pattern_t {
        kTriggerLvl1 = BIT(0),
        kCalibration = BIT(1), // Pulse Trigger
        kTriggerLvl2 = BIT(2), // LUT Pseudo Size selection
        kPedestal    = BIT(3),
        kPinDiode    = BIT(4),
        kSumTrigger  = BIT(5)  // Flag for an event taken with sum trigger
        //kUnused      = BIT(6)
        //kUnused      = BIT(7)
    };

private:
    Byte_t fPrescaled;   // Bit Pattern as defined above
    Byte_t fUnprescaled; // Bit Pattern as defined above

public:
    MTriggerPattern(const char *name=0, const char *title=0);

    void Reset() { fPrescaled=0; fUnprescaled=0; }

    Byte_t GetPrescaled() const   { return fPrescaled; }
    Byte_t GetUnprescaled() const { return fUnprescaled; }

    ClassDef(MTriggerPattern, 1) // Container storing the decoded trigger pattern
};

#endif
