#include <MThread.h>

using namespace std;

TString MyThreadX::GetThreadStateStr() const
{
    switch (fThread.GetState())
    {
    case TThread::kInvalidState:
        return "Invalid - thread was not created properly";
    case TThread::kNewState:
        return "New - thread object exists but hasn't started";
    case TThread::kRunningState:
        return "Running - thread is running";
    case TThread::kTerminatedState:
        return "Terminated - thread has terminated but storage has not yet been reclaimed (i.e. waiting to be joined)";
    case TThread::kFinishedState:
        return "Finished - thread has finished";
    case TThread::kCancelingState:
        return "Canceling - thread in process of canceling";
    case TThread::kCanceledState:
        return "Canceled - thread has been canceled";
    case TThread::kDeletingState:
        return "Deleting - thread in process of deleting";
    };
    return "Unknown";
}
