#ifndef COSY_VmodIcan
#define COSY_VmodIcan

#ifdef __CINT__
//#include <TROOT.h>
typedef UShort_t WORD_t;
typedef Byte_t   BYTE_t;
struct Message;
struct FastMessage;
#else
#include "gendef.h"
#include "dpm.h"
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

#ifndef COSY_Interface
#include "interface.h"
#endif

typedef struct timeval timeval_t;

class CanOpen;

class VmodIcan : public Interface, public MyThreadX
{
private:
    int fd; // file descriptor for can module

    // Specific tp the VmodIcan module
    int Ioctl(int msg, void *arg);

    void SetBaudRate(int rate);
    void EnableCanBusConnection();
    int  EnableFastCan(int rbuffers, int wbuffers);
    void DisableCanBusConnection();
    int  EnableFifo();
    int  Reset();
    void SetTermination(int strate=1);
    int  StdHost2NewStyle(int rbuffers, int wbuffers, int wbuffers_hi, int wbuffers_low);
    void DisableAllCobIds();

    void PrintMsg(Message *m);

    int Send(Message *pm);
    int SendHi(Message   *pm);
    int SendLo(Message   *pm);
    int Send(FastMessage *pm);

    void Close();
    int Open(const char *devname);          /* pathname of device */

    // Receiver
    int Receive(Message *pm);
    //int ReceiveFast(FastMessage *pm);
    Int_t Thread();

    void Start() { RunThread(); }
    void Stop()  { CancelThread(); }

public:
    VmodIcan(CanOpen *rx, const char *dev, const int baud);
    virtual ~VmodIcan();

    // Sending interface inherited from Interface
    void EnableCobId(WORD_t cobid, int flag=TRUE);
    void SendCanFrame(WORD_t cobid, BYTE_t m[8], BYTE_t rtr=0);

    ClassDef(VmodIcan, 0) // hardware interface to the vmodican can module (Janz)
};

#endif
