#ifndef COSY_SlaStars
#define COSY_SlaStars

#ifndef COSY_Slalib
#include "Slalib.h"
#endif

#ifndef MARS_MPointing
#include "MPointing.h"
#endif

class SlaStars : public Slalib
{
private:
    AltAz    fAltAz;    // [rad]
    RaDec    fRaDec;    // [rad]

    double   fAmprms[21];
    double   fAoprms[14];

public:
    SlaStars(MObservatory::LocationName_t key);
    virtual ~SlaStars();

    //    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    //    const ZdAz  GetZdAz()  const { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    //    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    virtual void SetMjd(double mjd);

    void   Set(const AltAz &altaz);
    void   Set(const ZdAz  &zdaz);
    void   Set(const RaDec &radec);

    ZdAz   GetApproxVel(const RaDec &radec) const; // [rad/rad];

    RaDec  CalcRaDec(const AltAz &altaz) const;
    RaDec  CalcRaDec(const ZdAz  &altaz) const;

    RaDec  CalcRaDecFast(const AltAz &altaz) const;
    RaDec  CalcRaDecFast(const ZdAz  &altaz) const;

    AltAz  CalcAltAz(const RaDec &radec) const;
    ZdAz   CalcZdAz (const RaDec &radec) const;

    AltAz  CalcAltAz(const RaDec &radec, double mjd)
    { SetMjd(mjd); return CalcAltAz(radec); }
    ZdAz   CalcZdAz (const RaDec &radec, double mjd)
    { SetMjd(mjd); return CalcZdAz(radec); }

    AltAz  CalcAltAzFast(const RaDec &radec) const;
    ZdAz   CalcZdAzFast (const RaDec &radec) const;

    ClassDef(SlaStars, 0)
};

#endif
