#ifndef COSY_Ethernet
#define COSY_Ethernet

#ifndef COSY_Interface
#include "interface.h"
#endif

#ifndef COSY_MTcpIpIO
#include "MTcpIpIO.h"
#endif

class Ethernet : public MTcpIpI, /*public MTcpIpO,*/ public Interface
{
private:
    TString fTxAddress;
    Int_t   fTxPort;

    // Send interface based on MTcpIpI
    void ReadSocket(TSocket &rx);

    // Start/stop communication inherited from Interface
    void Start() { RunThread(); }
    void Stop()  { CancelThread(); }

public:
    Ethernet(const char *addr, const int tx, const int rx, CanOpen *receiver);
    virtual ~Ethernet();

    // Transmit interface inherited from Interface
    void SendCanFrame(WORD_t cobid, BYTE_t m[8], BYTE_t rtr=0);

    ClassDef(Ethernet, 0) // hardware interface to the vmodican can module (Janz)
};

#endif
