#ifndef COSY_MCeCoCom
#define COSY_MCeCoCom

#ifndef ROOT_TString
#include <TString.h>
#endif

#ifndef COSY_MTcpIpIO
#include "MTcpIpIO.h"
#endif

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MCeCoCom : public MTcpIpIO
{
private:
    enum ComStatus_t
    {
        kCmdReceived,
        kNoCmdReceived,
        kComProblem
    };

    MLog *fOut;           // Stream to which reports are written in addition

//    Int_t fSendInterval; // [ms]
//    MTime fTime;

    MTime   fT;           // time of last report received
    char    fStatus;      // current status of this system
    int     fCCStatus;    // global status of CC

    ComStatus_t fComStat; // communication status

    Float_t fHumidity;         // [%]
    Float_t fTemperature;      // [deg] celsius
    Float_t fWindSpeed;        // [km/h]
    Float_t fSolarRadiation;   // [W/m^2] IR-Radiation

    Int_t   fAlarmCounter;     // Counter for alarm cases

    virtual bool InterpreteCmd(TString cmd, TString str);

    bool InterpreteReport(TString &str);
    bool InterpreteStr(TString str);

public:
    MCeCoCom(const char *addr, MLog *out)
        : MTcpIpIO(addr, 7304, 7404), fOut(out), fStatus(0), fComStat(kNoCmdReceived),
        fHumidity(0), fTemperature(0), fWindSpeed(0), fSolarRadiation(-1),
        fAlarmCounter(0)
    {
    }
    //virtual bool SendMsg(const char *msg, bool force);

    bool SendRep(const char *cmd, const char *str, bool force);
    void SetStatus(Byte_t s) { fStatus=s; }

    Float_t GetHumidity() const { return fHumidity; }
    Float_t GetTemperature() const { return fTemperature; }
    Float_t GetWindSpeed() const { return fWindSpeed; }

    TString GetWeather() const;
    Int_t   GetWeatherStatus() const;

    Bool_t  HasAlarm() const { return fAlarmCounter>3; }
};

#endif
