#ifndef COSY_MSlewing
#define COSY_MSlewing

#ifndef ROOT_TROOT
#include <TROOT.h>
#endif

class Macs;
class MCosy;
class ZdAz;

class MSlewing
{
protected:
    MCosy *fCosy;

    bool SetAccDec(Macs *mac, Float_t acc, Float_t dec);
    bool Break();

private:
    Float_t fVel;
    Float_t fAcc;
    Float_t fDec;

    void DoRelPos(const ZdAz &rd, const Bool_t axe1, const Bool_t axe2);
    void SetPosVelocity(const Float_t ratio, Float_t vel);

public:
    MSlewing(MCosy *cosy) : fCosy(cosy), fVel(0.1), fAcc(0.2), fDec(0.1) { }

    void SetPointAccDec(Float_t acc, Float_t dec) { fAcc = acc; fDec = dec; }
    void SetPointVelocity(Float_t vel) { fVel = vel; }
    int  SetPosition(const ZdAz &dst, Bool_t track=kFALSE);

    ClassDef(MSlewing, 0)
};

#endif
