/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  MFillHHillas                                                            //
//                                                                          //
//  This task fills the hillas parameter from MHillas into                  //
//  histograms (MHHillas)                                                   //
//                                                                          //
//  Input Containers:                                                       //
//   MHillas                                                                //
//                                                                          //
//  Output Containers:                                                      //
//   MHHillas                                                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include "MFillH.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MH.h"
#include "MParList.h"

ClassImp(MFillH);

// --------------------------------------------------------------------------
void MFillH::Init(const char *name, const char *title)
{
    *fName  = name  ? name  : "MFillH";
    *fTitle = title ? title : "Task to fill Mars histograms";
}

MFillH::MFillH(const char *par, const char *hist, const char *name, const char *title)
{
    Init(name, title);

    fParContainerName = par;
    fHName = hist;
}

MFillH::MFillH(const MParContainer *par, const char *hist, const char *name, const char *title)
{
    Init(name, title);

    fParContainer = par;
    fHName = hist;
}

MFillH::MFillH(const char *par, MH *hist, const char *name, const char *title)
{
    Init(name, title);

    fParContainerName = par;
    fH = hist;
}

MFillH::MFillH(const MParContainer *par, MH *hist, const char *name, const char *title)
{
    Init(name, title);

    fParContainer = par;
    fH = hist;
}

// --------------------------------------------------------------------------
Bool_t MFillH::PreProcess(MParList *pList)
{
    if (!fParContainer)
    {
        fParContainer = (MParContainer*)pList->FindObject(fParContainerName);
        if (!fParContainer)
        {
            *fLog << dbginf << fParContainerName << " not found... aborting." << endl;
            return kFALSE ;
        }
    }

    if (!fH)
    {
        fH = (MH*)pList->FindCreateObj(fHName);
        if (!fH)
            return kFALSE;
    }

    return kTRUE ;
} 

// --------------------------------------------------------------------------
Bool_t MFillH::Process()
{
    fH->Fill(fParContainer);

    return kTRUE;
} 

Bool_t MFillH::PostProcess()
{
    fH->SetReadyToSave();
    return kTRUE;
}
