#ifndef MARS_MSequenceSQL
#define MARS_MSequenceSQL

#ifndef MARS_MSequence
#include "MSequence.h"
#endif

class TSQLRow;
class TSQLResult;

class MSQLMagic;

class MSequenceSQL : public MSequence
{
private:
    Bool_t  GetRuns(MSQLMagic &serv, TString query, char type='*', UInt_t nevts=(UInt_t)-1);
    TString GetTimeFromDatabase(MSQLMagic &serv, const TString &query);
    Bool_t  GetFromDatabase(MSQLMagic &serv, TSQLResult &res);
    Bool_t  GetFromDatabase(MSQLMagic &serv, TSQLRow &data);

public:
    MSequenceSQL(MSQLMagic &serv, Int_t seqno=-1)  { GetFromDatabase(serv, seqno); }
    MSequenceSQL(const char *rc, Int_t seqno=-1)   { GetFromDatabase(rc, seqno); }
    MSequenceSQL(Int_t seqno=-1)                   { GetFromDatabase(seqno); }

    Bool_t GetFromDatabase(MSQLMagic &serv, Int_t seqno=-1);
    Bool_t GetFromDatabase(const char *rc, Int_t seqno=-1);
    Bool_t GetFromDatabase(Int_t seqno=-1) { return GetFromDatabase("sql.rc", seqno); }

    ClassDef(MSequenceSQL, 0) // Extension of MSequence to get a sequence from a database
};

#endif
