#ifndef MARS_MReadFiles
#define MARS_MReadFiles

#ifndef MARS_MRead
#include "MRead.h"
#endif

class MZlib;

class MReadFiles : public MRead
{
private:
    TList     fFileNames;  // Array which stores the \0-terminated filenames

    TString   fFileName;   // Currently open file

    UInt_t    fNumFile;    // File number in sequence
    UInt_t    fNumLine;    // Line number in file

    MParList *fParList;    //! Parlist for reinitialization

protected:
    MZlib    *fIn;         // the inputfile

    Bool_t ReadLine(TString &line);

    UInt_t GetNumLine() const { return fNumLine; }

    Int_t  PreProcess(MParList *pList);
    Int_t  Process();

private:
    Bool_t OpenNextFile();
    Bool_t CheckFile(TString name) const;

    virtual Bool_t AnalyzeHeader(MParList &plist)=0;
    virtual Bool_t ReadHeader()=0;
    virtual Int_t  ReadEvent()=0;

public:
    MReadFiles(const char *filename=NULL, const char *name=NULL,
               const char *title=NULL);
    ~MReadFiles();

    Int_t AddFile(const char *fname, int i=0);

    Bool_t  Rewind();
    void    Close();
    TString GetFullFileName() const { return fFileName; }

    ClassDef(MReadFiles, 0) // Base class to read a chain of files
};

#endif
