void getRate(int dim=0, char *filename = "/big0/Maggi/CamData/Gamma/gamma_15_on.root" )
{
    // This macro has two input parameter:
    // dim : = 0 -> root file with 1 trigger condition.
    //       > 0 -> number of trigger condition to be analised 
    //              in multi conditon file.
    //       < 0 -> selects the -dim trigger condition.
    //
    // first we have to create our empty lists
    //
    MParList  parlist;
    MTaskList tasklist;

    //
    // Setup the parameter list.
    //  - we do not need to create any other container. All of them
    //    are created automatically without loss - we don't have to
    //    access them-
    //
    //  - we need to create MHMcRate only. The other containers
    //    are created automatically without loss - we don't have to
    //    access them-
    //  - MHMcRate must be created by us because we need the pointer
    //    to it and if it would get created automatically it would also be
    //    deleted automatically
    //  - Actually, depending on using a single trigger option MonteCarlo
    //    file or a multyple trigger option, a MHMcRate or an array of 
    //    MHMcRate are needed.
    
    parlist.AddToList(&tasklist);

    if (dim==0){
      MHMcRate *rate = new MHMcRate();
      parlist.AddToList(rate);
    }
    if (dim<0){
      char *name = new char[8];
      name="MHMcRate";
      char *auxname = new char[8+7];
      strcpy(auxname, name);
      sprintf(auxname+8, ";%d", -dim);
      MHMcRate *ratem = new MHMcRate(auxname);
      parlist.AddToList(ratem);
    }
    else{ 
      MHMcRate **ratep = new MHMcRate *[dim];
      char *name = new char[8];
      name="MHMcRate";
      char *auxname = new char[8+7];
      strcpy(auxname, name);
      for(int i=0;i<dim;i++){
	sprintf(auxname+8, ";%d", i+1);
	ratep[i] = new MHMcRate(auxname);
	parlist.AddToList(ratep[i]);
      }
    }

    //
    // Setup out tasks:
    //  - First we have to read the events
    //  - Then we can calculate rates, for what the number of
    //    triggered showers from a empty reflector file for the
    //    analised trigger conditions should be set (BgR[])
    //
    MReadTree reader("Events", filename);
    tasklist.AddToList(&reader);

    Float_t BgR[10]={660,4,0,0,0,0,0,0,0,0};
    cout<<dim<<endl;

    MMcTriggerRateCalc rate(dim, 14, BgR, 100000, 2.75, 10.91e-2);
    tasklist.AddToList(&rate);

    //
    // set up the loop for the processing
    //
    MEvtLoop magic;
    magic.SetParList(&parlist);

    //
    // Start to loop over all events
    //
    magic.Eventloop();

}
