/* ======================================================================== *\
! $Name: not supported by cvs2svn $:$Id: plotusage.C,v 1.1 2008-08-14 11:20:37 dorner Exp $
! --------------------------------------------------------------------------
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz, 06/2008 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2008
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// plotusage.C
// ===========
//
// This macro is used to read quality parameters from the DB and plot them.
// 
// Usage:
//   .x plotusage.C   --> all values in the DB are plotted
// You can chose are certain period:
//   .x plotusage.C(25)   --> all values from period 25 are plotted
// or a time period from a certain date to a certain date
//   .x plotusage.C("2004-11-14 00:00:00", "2005-02-28 00:00:00")
//  --> all values from 14.11.2004 0h to 28.2.2005 0h are plotted
//
// Make sure, that database and password are corretly set in a resource
// file called sql.rc and the resource file is found.
//
/////////////////////////////////////////////////////////////////////////////
#include "plotdb.C"

void plotallusage(MPlot &plot)
{
    // plot.SetGroupBy(MPlot::kGroupByDay);

    plot.SetPrimaryDate("CondorStatus.fTime");

    // plot.SetPrimaryNumber("Sequences.fSequenceFirst");
    // plot.SetCondition("((Sequences.fSequenceFirst>95000 AND Sequences.fSequenceFirst<261988) OR Sequences.fSequenceFirst>267750)"
    //                   "AND Star.fAvgTemperature<25 AND Star.fMuonNumber>500");

    plot.SetSecondary("CondorStatus.fLoadTotal");
    plot.SetDescription("Total number of available CPUs;Available CPUs", "TotCPU");
    plot.Plot("CondorStatus.fNumTotal as CPUs",  0,  50, 1);

    plot.SetSecondary("CondorStatus.fLoadClaimed");
    plot.SetDescription("Total number of claimed CPUs;Claimed CPUs", "ClaimedCPU");
    plot.Plot("CondorStatus.fNumClaimed as CPUs",  0,  50, 1);

    plot.SetSecondary("CondorStatus.fNumClaimed");
    plot.SetDescription("Total load of available CPUs;Total load", "AbsTotLoad");
    plot.Plot("CondorStatus.fLoadTotal",  0,  50, 1);

    plot.SetSecondary("CondorStatus.fNumClaimed");
    plot.SetDescription("Total load of claimed CPUs;Claimed load", "AbsClaimedLoad");
    plot.Plot("CondorStatus.fLoadClaimed",  0,  50, 1);

    plot.SetSecondary("CondorStatus.fNumClaimed");
    plot.SetDescription("Relative load per available CPUs;Relative load", "RelTotLoad");
    plot.Plot("CondorStatus.fLoadTotal/CondorStatus.fNumTotal",  0,  1.2, 0.02);

    plot.SetSecondary("CondorStatus.fNumClaimed");
    plot.SetDescription("Relative load per claimed CPUs;Relative load", "RelClaimedLoad");
    plot.Plot("CondorStatus.fLoadClaimed/CondorStatus.fNumClaimed",  0,  1.2, 0.02);
}

int plotusage(TString from, TString to, const char *dataset=0)
{
    MSQLMagic serv("sql.rc");
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }

    cout << "plotusage" << endl;
    cout << "---------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    MStatusDisplay *d = new MStatusDisplay;
    d->SetWindowName(serv.GetName());
    d->SetTitle(serv.GetName());

    MPlot plot(serv);
    plot.SetDataSet(dataset);
    plot.SetDisplay(d);
    plot.SetRequestRange(from, to);

    plotallusage(plot);

    d->SaveAsRoot("plotusage.root");
//    d->SaveAsPS("plotdb.ps");

    return 1;
}

int plotusage(const char *ds)
{
    MSQLMagic serv("sql.rc");
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }

    cout << "plotusage" << endl;
    cout << "---------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    MStatusDisplay *d = new MStatusDisplay;
    d->SetWindowName(serv.GetName());
    d->SetTitle(serv.GetName());

    MPlot plot(serv);
    plot.SetDataSet(ds);
    plot.SetDisplay(d);
    plot.SetRequestRange("", "");

    plotallusage(plot);

    d->SaveAsRoot("plotusage.root");
//    d->SaveAsPS("plotdb.ps");

    return 1;
}

int plotusage(Int_t period, const char *dataset="")
{
    MSQLMagic serv("sql.rc");
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }

    cout << "plotusage" << endl;
    cout << "---------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    MStatusDisplay *d = new MStatusDisplay;
    d->SetWindowName(serv.GetName());
    d->SetTitle(serv.GetName());

    MPlot plot(serv);
    plot.SetDataSet(dataset);
    plot.SetDisplay(d);
    plot.SetRequestPeriod(period);

    plotallusage(plot);

    d->SaveAsRoot("plotusage.root");
//    d->SaveAsPS("plotdb.ps");

    return 1;
}

int plotusage()
{
    return plotusage("", "");
}
