#include "Slalib.h"

#include <time.h>
#include <iostream.h>  // cout

#include "slalib.h"

Slalib::Slalib()
{
    // p = pointer to MainFrame (not owner)

    //
    // calculate observers location (goe)
    //
    int status;
    slaDaf2r(51, 38, 48.0, &fPhi,   &status);
    slaDaf2r( 9, 56, 36.0, &fElong, &status);

    cout << "Latitude: 5138'48.0\" = " <<  360.0/D2PI*fPhi << "   ";
    cout << "Longitude: 956'36.0\" = " <<  360.0/D2PI*fElong << endl;
}

Slalib::~Slalib()
{
}

void Slalib::Set(const AltAz &altaz)
{
    fAltAz = altaz * D2PI/360.0;
    fRaDec = CalcRaDec(fAltAz);
}

void Slalib::Set(const ZdAz &zdaz)
{
    fAltAz = AltAz(DPI/2-zdaz.Zd(), zdaz.Az()) * D2PI/360.0;
    fRaDec = CalcRaDec(fAltAz);
}

void Slalib::Set(const RaDec &radec)
{
    fRaDec = radec * D2PI/360.0;
    fAltAz = CalcAltAz(fRaDec);
}

void Slalib::Set(const double mjd)
{
    fMjd   = mjd;
    fAlpha = slaGmst(fMjd) + fElong;

    //
    // ----- calculate star independent parameters ----------
    //
    slaMappa(2000.0, fMjd, fAmprms);
    slaAoppa(fMjd, 0,                // mjd, UT1-UTC
             fElong, fPhi, 148,      // gttingen long, lat, height
             0, 0,                   // polar motion x, y-coordinate (radians)
             273.155, 1013.25, 0.5,  // temp, pressure, humidity
             0.2, 0.0065,            // wavelength, tropo lapse rate
             fAoprms);
}

RaDec Slalib::CalcRaDec(const AltAz &altaz) const
{
    return CalcRaDec(ZdAz(DPI/2-altaz.Alt(), altaz.Az()));
}

RaDec Slalib::CalcRaDec(const ZdAz &zdaz) const
{
    //
    // -- observed to apparent --
    //  Workaraound for slalib: discard const
    //
    double r=0, d=0;
    slaOapqk ("A", zdaz.Az(), zdaz.Zd(), (double*)fAoprms, &r, &d);

    //
    // -- apparent to mean --
    //  Workaraound for slalib: discard const
    //
    double ra, dec;
    slaAmpqk(r, d, (double*)fAmprms, &ra, &dec);

    return RaDec(ra, dec);
}

ZdAz Slalib::CalcZdAz(const RaDec &radec) const
{
    //
    // ---- Mean to apparent ----
    //

    double r=0, d=0;
    slaMapqkz(radec.Ra(), radec.Dec(), (double*)fAmprms, &r, &d);
    //
    // Doesn't work - don't know why
    //
    //    slaMapqk (radec.Ra(), radec.Dec(), rdpm.Ra(), rdpm.Dec(),
    //              0, 0, (double*)fAmprms, &r, &d);
    //

    //
    // -- apparent to observed --
    //
    double r1=0;  // ra
    double d1=0;  // dec
    double h0=0;  // ha

    double zd;
    double az;
    slaAopqk (r, d, (double*)fAoprms,
              &az,    // observed azimuth (radians: N=0,E=90)
              &zd,    // observed zenith distance (radians) [-pi/2, pi/2]
              &h0,    // observed hour angle (radians)
              &d1,    // observed declination (radians)
              &r1);   // observed right ascension (radians)

    return ZdAz(zd, az);
}
AltAz Slalib::CalcAltAz(const RaDec &radec) const
{
    ZdAz zdaz = CalcZdAz(radec);
    return AltAz(DPI/2-zdaz.Zd(), zdaz.Az());
}

