#ifndef SLALIB_H
#define SLALIB_H

#include "coord.h"

class Slalib
{
private:
    double   fPhi;      // location of observatory
    double   fElong;

    AltAz    fAltAz;    // [rad]
    RaDec    fRaDec;    // [rad]

    double   fAlpha;
    double   fMjd;

    double   fAmprms[21];
    double   fAoprms[14];

public:
    Slalib();
    virtual ~Slalib();

    //    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    //    const ZdAz  GetZdAz()  const { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    //    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    void   Set(const double mjd);

    void   Set(const AltAz &altaz);
    void   Set(const ZdAz  &zdaz);
    void   Set(const RaDec &radec);

    double GetAlpha() const { return fAlpha; }

    double GetPhi() const   { return fPhi; }
    double GetElong() const { return fElong; }

    RaDec  CalcRaDec(const AltAz &altaz) const;
    RaDec  CalcRaDec(const ZdAz  &altaz) const;

    AltAz  CalcAltAz(const RaDec &radec) const;
    ZdAz   CalcZdAz (const RaDec &radec) const;

};

#endif
