//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGSkyPosition.h"

#include <iostream.h>  // cout
#include <TRootEmbeddedCanvas.h>
#include <TGWindow.h>
#include <TArc.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TLine.h>

#include "coord.h"

MGSkyPosition::MGSkyPosition(const TGWindow* p)
: TRootEmbeddedCanvas("SkyPosition", p, 50, 50, kSunkenFrame)//, 0) //234, 76, kFixedSize)
{
    fCanvas = GetCanvas();

    fCanvas->Range(-100, -100, 100, 100);

    fArc = new TArc;
    fArc->SetLineColor(15);
    fArc->DrawArc(0, 0, 90);
    fArc->DrawArc(0, 0, 67.5);
    fArc->DrawArc(0, 0, 45);
    fArc->DrawArc(0, 0, 22.5);

    fLin1 = new TLine;
    fLin1->DrawLine(-95,   0, 95,  0);
    fLin1->DrawLine(  0, -95,  0, 95);
    fLin2 = new TLine;

    //    fCanvas->Modified();
    //    fCanvas->Update();

    MapSubwindows();
    //    MapWindow();

    //    DrawPosition(66, 25);
    //    DrawPosition(22, 278);
}

MGSkyPosition::~MGSkyPosition()
{
    delete fLin1;
    delete fLin2;
    delete fArc;

    cout << "MGSkyPosition destroyed." << endl;
}

void MGSkyPosition::DrawPosition(Float_t zd, Float_t az)
{
    static int X=~0;
    static int Y=~0;

    const float rad = D2PI*az/360.0;

    const float s = sin(rad);
    const float c = cos(rad);

    const int x = (int)(s*zd);
    const int y = (int)(c*zd);

    if (X==x && Y==y)
        return;

    const int dx = (int)(s*6);
    const int dy = (int)(c*6);

    delete fArc;
    fArc = new TArc(x, y, 2);
    fArc->SetFillStyle(1001);
    fArc->SetFillColor(43);
    fArc->Draw();

    delete fLin1;
    delete fLin2;
    //fLin1 = new TLine(x-dx, y-dy, x+dx, y+dy);
    fLin1 = new TLine(0, 0, s*95, c*95);
    fLin2 = new TLine(x+dy, y-dx, x-dy, y+dx);
    fLin1->Draw();
    fLin2->Draw();

    fCanvas->Update();
}

void MGSkyPosition::DrawPosition(ZdAz &pos)
{
    DrawPosition(pos.Zd(), pos.Az());
}
