#ifndef SLAPLANETS_H
#define SLAPLANETS_H

#ifndef SLALIB_H
#include "Slalib.h"
#endif

typedef enum
{
    kESun      = 0,
    kEMercury  = 1,
    kEVenus    = 2,
    kEMoon     = 3, // earth moon barycentre
    kEMars     = 4,
    kEJupiter  = 5,
    kESaturn   = 6,
    kEUranus   = 7,
    kENeptune  = 8,
    kEPluto    = 9
} ePlanets_t;

class SlaPlanets : public Slalib
{
private:
    const double fDt;

    ZdAz fZdAz[10];    // [rad]

    double fEarth[3];  // heliocentric coordinates

    ZdAz   GetMoonPos() const;

public:
    SlaPlanets();
    virtual ~SlaPlanets();

    //    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    //    const ZdAz  GetZdAz()  const { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    //    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    void SetMjd(const double mjd);

    void UpdatePlanetPos(ePlanets_t planet);
    ZdAz GetPlanetPos(ePlanets_t planet) const { return fZdAz[planet]; }

};

#endif
