#ifndef MGSKYPOSITION_H
#define MGSKYPOSITION_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)


#ifndef ROOT_TRootEmbeddedCanvas
#include <TRootEmbeddedCanvas.h>
#endif

class TArc;
class TList;
class TLine;
class TCanvas;

class ZdAz;
class SlaPlanets;

class MGSkyPosition : public TRootEmbeddedCanvas
{
    TCanvas    *fCanvas;

    TArc       *fMoon;
    TArc       *fJupiter;
    TArc       *fVenus;
    TArc       *fMars;
    TArc       *fSun;

    TLine      *fLin1a;
    TLine      *fLin1b;
    TLine      *fLin2;

    TLine      *fSunL[4];

    SlaPlanets *fSlalib;

    TList      *fList;

    Int_t fX[9];
    Int_t fY[9];

    Bool_t fModified;

    void InitPlanets();
    void InitPosition();

    void SetLin1(int x, int y);
    void SetLin2(int x1, int y1, int x2, int y2);

    void DrawPlanet(Int_t planet, TArc *arc);
    void DrawPosition(Float_t zd, Float_t az);
    void DrawCoordinateSystem();

    Bool_t CheckRange(Int_t x, Int_t y) const
    {
        return x>-95 && x<95 && y>-95 && y<95;
    }

public:
    MGSkyPosition(const TGWindow* p, const Int_t w, const Int_t h);
    ~MGSkyPosition();

    void Update(ZdAz &pos);
};

#endif // MGSKYPOSITION_H
