//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGAccuracy.h"

#include <iostream.h>  // cout

#include <TArc.h>
#include <TLine.h>
#include <TList.h>
#include <TCanvas.h>

#include "coord.h"

void MGAccuracy::DrawCoordinateSystem()
{
    TLine line;

    line.SetLineColor(13);
    line.SetLineStyle(3);  // dotted  (s. TAttLine)
    line.DrawLine(-.5,  -1.05, -.5,   1.05);
    line.DrawLine( -1.05, -.5,   1.05, -.5);
    line.DrawLine( .5,  -1.05,  .5,   1.05);
    line.DrawLine( -1.05,  .5,   1.05,  .5);

    line.DrawLine(-.25,  -1.05, -.25,   1.05);
    line.DrawLine( -1.05, -.25,   1.05, -.25);
    line.DrawLine( .25,  -1.05,  .25,   1.05);
    line.DrawLine( -1.05,  .25,   1.05,  .25);

    line.DrawLine(-.75,  -1.05, -.75,   1.05);
    line.DrawLine( -1.05, -.75,   1.05, -.75);
    line.DrawLine( .75,  -1.05,  .75,   1.05);
    line.DrawLine( -1.05,  .75,   1.05,  .75);

    line.SetLineColor(12);
    line.SetLineStyle(2);  // dashed  (s. TAttLine)
    line.DrawLine(-1, -1.05, -1,  1.05);
    line.DrawLine(-1.05, -1,  1.05, -1);
    line.DrawLine( 1, -1.05,  1,  1.05);
    line.DrawLine(-1.05,  1,  1.05,  1);

    line.SetLineColor(1);  // black
    line.SetLineStyle(1);  // solid  (s. TAttLine)
    line.DrawLine(-1.05,     0, 1.05,    0);
    line.DrawLine(    0, -1.05,    0, 1.05);

    TArc arc;
    arc.SetFillStyle(4000);  // transparent
    arc.SetFillColor(39);
    arc.SetLineColor(3);     // green
    arc.SetLineStyle(2);     // dashed  (s. TAttLine)
    arc.DrawArc(0, 0, 20./60);

    arc.SetLineColor(5);     // yellow
    arc.DrawArc(0, 0, 40./60);

    arc.SetLineColor(2);     // red
    arc.DrawArc(0, 0, 1);
}

void MGAccuracy::InitPosition()
{
    fLin1 = new TLine(0, 0, 0, 0);
    fLin2 = new TLine(0, 0, 0, 0);

    fLin1->SetLineColor(10); // white (s. TAttFill)
    fLin2->SetLineColor(10); // white
    fLin1->SetLineStyle(1);  // solid (s. TAttLine)
    fLin2->SetLineStyle(1); 

    fLin1->Draw();
    fLin2->Draw();

    fList->Add(fLin1);
    fList->Add(fLin2);
}

MGAccuracy::MGAccuracy(const TGWindow* p, const Int_t w, const Int_t h)
    : TRootEmbeddedCanvas("Accuracy", p, w-1, h-1, kRaisedFrame),//, 0) //234, 76, kFixedSize)
    fModified(kFALSE)
{
    fCanvas = GetCanvas();

    fCanvas->SetFillColor(39); // s. TAttFill
    fCanvas->Range(-1.1, -1.1, 1.1, 1.1);

    fList = new TList;
    fList->SetOwner();

    DrawCoordinateSystem();
    InitPosition();

    Resize(w, h); //GetDefaultSize()); // ???

    MapSubwindows();
}

MGAccuracy::~MGAccuracy()
{
    delete fList;

    cout << "MGAccuracy destroyed." << endl;
}

void MGAccuracy::Update(ZdAz &zdaz)
{
    //
    // calculate actual time for planet positions
    //

    fLin1->SetX1(zdaz.Zd()*60.-0.02);
    fLin1->SetX2(zdaz.Zd()*60.+0.02);

    fLin2->SetX1(zdaz.Zd()*60.-0.02);
    fLin2->SetX2(zdaz.Zd()*60.+0.02);

    fLin1->SetY1(zdaz.Az()*60.-0.02);
    fLin1->SetY2(zdaz.Az()*60.+0.02);

    fLin2->SetY1(zdaz.Az()*60.+0.02);
    fLin2->SetY2(zdaz.Az()*60.-0.02);

    fCanvas->Modified();
    fCanvas->Update();

    /*
    DrawPosition(pos.Zd(), pos.Az());

    if (!fModified)
        return;

    // FIXME: Sometimes (if the canvas couldn't be created correctly:
    // X11 Pixmap error) Update hangs the Gui system.

    fModified = kFALSE;
    */
}
