#ifndef MCOSY_H
#define MCOSY_H

#include "coord.h"
#include "msgqueue.h"
#include "network.h"
#include "MThread.h"

#define kDEG ((char)0xb0)  // Linux ''

#define WM_WAIT      WM_NULL
#define WM_PRESET    0x1000
#define WM_POSITION  0x1001
#define WM_TRACK     0x1002
#define WM_STOP      0x1003
#define WM_POLARIS   0x1004

class ShaftEncoder;
class Macs;
class MGCosy;
class MCosy;

/*
class MTGui : public MThread
{
private:
    MCosy *fCosy;

    void *Thread();

public:
    MTGui(MCosy *cosy) : MThread(false), fCosy(cosy)
    {
        SetPriority(20);
        Start();
    }
};
*/

class MTTalk : public MThread
{
private:
    MCosy *fCosy;

    void *Thread();

public:
    MTTalk(MCosy *cosy) : MThread(false), fCosy(cosy)
    {
        SetPriority(10);
        Detach();
        Start();
    }
};
class TTimer;
class MCosy : public Network, public MsgQueue, public TObject
{
    friend class MTGui;
    friend class MTTalk;

private:
    ShaftEncoder *fAlt1;
    ShaftEncoder *fAlt2;
    ShaftEncoder *fAz;

    Macs *fMac1;
    Macs *fMac2;
    Macs *fMac3;

    MGCosy *fWin;

    TTimer *fUpdateGui;

    //MTGui  *fTGui;
    MTTalk *fTTalk;

    ZdAz  fTrackingError; // Tracking Offset between SE and calc-pos [re]
    ZdAz  fOffset;        // Offset between se and re coordinate system [re]
    RaDec fRaDec;         // Position to track
    int   fTracking;      // Flag for present tracking action
    ZdAz  fAccuracy;      // Actual accuracy of Tracking
    ZdAz  fVelocity;      // Actual velocity of Tracking

    ZdAz GetRePos();
    ZdAz GetRePosPdo();
    ZdAz GetSePos();     // [se]

    void TalkThread();
    void GuiThread(MTGui *t);

    int  SetPosition(const ZdAz &dst);

    void TerminateApp();

    void TrackPosition(const RaDec &dst); // ra, dec [rad]

    int StopWaitingForSDO() const;

public:
    MCosy(const char *dev, const int baud, ostream &out=cout);
    ~MCosy();

    void Start();
    void Stop();

    void *Proc(int msg, void *mp);

    Bool_t HandleTimer(TTimer *t);

    static ZdAz CorrectTarget(const ZdAz &src, const ZdAz &dst);
//    static ZdAz RaDec2ZdAz(const double mjd, const RaDec &pos, const RaDec &pm=RaDec(0,0));

};

#endif
