//
// This File contains the definition of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include "MGEmbeddedCanvas.h"

#include <TList.h>
#include <TCanvas.h>

MGEmbeddedCanvas::MGEmbeddedCanvas(const char *name, const TGWindow* p,
                                   const UInt_t width, Float_t range)
    : TRootEmbeddedCanvas(name, p, width+1, width+1, kRaisedFrame),//, 0) //234, 76, kFixedSize)
      fModified(kFALSE), fWidth(width), fRange(range), fPix(2.*range/width)
{
    fCanvas = GetCanvas();

    fCanvas->SetFillColor(39); // s. TAttFill
    fCanvas->Range(-fRange, -fRange, fRange, fRange);

    fList = new TList;
    fList->SetOwner();
}

MGEmbeddedCanvas::~MGEmbeddedCanvas()
{
    delete fList;
}

void MGEmbeddedCanvas::InitCanvas()
{
    MapSubwindows();

    Resize(fWidth, fWidth); //GetDefaultSize()); // ???
    MapWindow();

    fCanvas->SetEditable(kFALSE);
}

void MGEmbeddedCanvas::UpdateCanvas()
{
    if (!fModified)
        return;

    //
    // FIXME: Sometimes (if the canvas couldn't be created correctly:
    // X11 Pixmap error) Update hangs the Gui system.
    //
    // Fixed: Using root 3.01/06 and doing the update from within the
    // mainthread.
    //

    fCanvas->Modified();
    fCanvas->Update();

    fModified = kFALSE;
}
