#ifndef MARS_MSimTrigger
#define MARS_MSimTrigger

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MLut
#include "MLut.h"
#endif

class MParList;
class MParameterD;
class MAnalogChannels;
class MRawEvtHeader;
class MRawRunHeader;

class MSimTrigger : public MTask
{
private:
    MAnalogChannels *fCamera;         //! The analog input channels
    MParameterD     *fPulsePos;       //! The intended pulse positon
    MParameterD     *fTrigger;        //! The trigger position w.r.t. the analog channels
    MRawRunHeader   *fRunHeader;      //! The run header storing infos about the digitization
    MRawEvtHeader   *fEvtHeader;      //! The event header storing the trigger information

    MLut fRouteAC;                    // Combinination map for the AC channels
    MLut fCoincidenceMap;             // channels for which digital coincidence is checked

    TString fNameRouteAC;             // Name for the AC routing
    TString fNameCoincidenceMap;      // Name for the coincidence mape

    Float_t fDiscriminatorThreshold;  // Discriminator threshold

    // MSimTrigger
    TObjArray *CalcCoincidence(const TObjArray &arr1, const TObjArray &arr2, Float_t gate=0) const;

    // MTask
    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MSimTrigger(const char *name=NULL, const char *title=NULL);

    void SetNameRouteAC(const char *name) { fNameRouteAC=name; }
    void SetNameCoincidenceMap(const char *name) { fNameCoincidenceMap=name; }

    void SetDiscriminatorThreshold(Float_t th) { fDiscriminatorThreshold=th; }

    ClassDef(MSimTrigger, 0) // Task to simulate trigger electronics
};

#endif
