#ifndef MARS_MSimCamera
#define MARS_MSimCamera

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MPhotonEvent;
class MPhotonStatistics;
class MRawRunHeader;
class MAnalogChannels;

class TF1;
class MSpline3;

class MSimCamera : public MTask
{
private:
    MPhotonEvent      *fEvt;        //! Event stroing the photons
    MPhotonStatistics *fStat;       //! Valid time range of the phootn event
    MRawRunHeader     *fRunHeader;  //! Sampling frequency

    MAnalogChannels   *fCamera;     //! Output of the analog signals

    MSpline3          *fSpline;     //! Spline to describe the pulse shape

    TString fFileName;              // File name of a file describing the pulse shape

    TString fFunction;              // Function describing the pulse shape
    Int_t   fNpx;                   // Number of
    Float_t fXmin;
    Float_t fXmax;

    // MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print=kFALSE);

    // MTask
    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Bool_t ReInit(MParList *pList);

    Bool_t ReadFile(const char *fname);
    Bool_t SetFunction(const char *func, Int_t n, Double_t xmin, Double_t xmax);

public:
    MSimCamera(const char *name=NULL, const char *title=NULL);
    ~MSimCamera();

    void SetFunction(const TF1 &f);
    void SetFunction(const char *f)  { fFunction=f; fFileName=""; }
    void SetFileName(const char *n)  { fFileName=n; fFunction=""; }

    void Clear(Option_t *o="");

    ClassDef(MSimCamera, 0) // Task to simulate the electronic noise and to convert photons into pulses
};

#endif
