#ifndef MARS_MCameraCentralPix
#define MARS_MCameraCentralPix

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MCameraCentralPix : public MParContainer
{
    friend class MReportCamera;

private:
    Bool_t fStatus; // Status of central pixel

    Float_t fDC;    // [nA]

public:
    MCameraCentralPix() : fDC(-1)
    {
        fName  = "MCameraCentralPix";
        fTitle = "Container storing information about the Camera Central Pixel";
    }

    Bool_t GetStatus() const     { return fStatus; }
    Bool_t GetStatusCPix() const { return fStatus; } // deprecated - for compatibility only

    ClassDef(MCameraCentralPix, 2) // Container storing information about the Central Pixel status
};

#endif
