
/********************************************************************\

  Name:         HVConfig.cc

  Created by:   Sebastian Commichau, November 2008
                commichau@phys.ethz.ch

  Contents:     Class reading the HV utility configuration file

\********************************************************************/

#include "HVConfig.h"


HVConfig::HVConfig(const char *configfile) {

  fUSBDevice = new char*[MAX_NUM_HVBOARDS];

  for (int i=0; i<MAX_NUM_HVBOARDS; i++) {
    fUSBDevice[i]      = new char[BUFFER_LENGTH];
    USBDeviceNumber[i] = 0;
  }

  TestMode           = false;
  NumHVBoards        = 0;
  fStatusRefreshRate = 1.;
  fTimeOut           = 1.;
  DACMin             = 11008;
  DACMax             = 12496;
  fHVCalibOffset      = -.8;
  fHVCalibSlope       = 0.0064;
  fHVMaxDiff          = 1;
  
  // Read configuration file
  FILE *f;
  char str[MAX_COM_SIZE], dev[MAX_COM_SIZE];
  int j = 0;

  if ((f = fopen(configfile,"r")) == NULL) {
    printf("Could not open configuration file: %s\n", configfile);
    throw;
  }
  else printf("Opening configuration file: %s\n", configfile);
 
  ReadCard("LogFile",       fLogFile,    's',f);
  ReadCard("PixMapTable",   fPixMapTable,'s',f);
  ReadCard("SlowDirectory", fSlowDir,	 's',f);
  
  ReadCard("TestMode",   &str,        's',f);
  if (!strcmp(str,"TRUE")) TestMode = true;

  for (int i=0; i<MAX_NUM_HVBOARDS; i++) {
    sprintf(str,"Board%d",i);

    if (ReadCard(str, dev, 's', f)) {
      USBDeviceNumber[j] = i;
      sprintf(fUSBDevice[j++],"%s",dev);
      NumHVBoards++;     
    }
  }
  
  ReadCard("TimeOut",           &fTimeOut,           'f', f);
  ReadCard("StatusRefreshRate", &fStatusRefreshRate, 'f', f);
  ReadCard("CCPort",            &fCCPort,            'I', f);
  ReadCard("DACMin",            &DACMin,             'I', f);
  ReadCard("DACMax",            &DACMax,             'I', f);
  ReadCard("HVCalibOffset",     &fHVCalibOffset,     'f', f);
  ReadCard("HVCalibSlope",      &fHVCalibSlope,      'f', f);
  ReadCard("HVMaxDiff",         &fHVMaxDiff,         'U', f);

  fclose(f);
}


HVConfig::~HVConfig() {

  for (int i=0; i<MAX_NUM_HVBOARDS; i++) delete [] fUSBDevice[i];
  delete [] fUSBDevice;
}


// ReadCard function (original version by F. Goebel)
// Data is read into an array if MaxNum is larger than 1
bool ReadCard(const char *card_flag, void *store, char Type, FILE *File, unsigned int MaxNum) {
  
  char *card_name, *card_val, Buffer[MAX_COM_SIZE];
  unsigned int Count=0;
  
  rewind(File);

  while (fgets(Buffer, sizeof(Buffer), File) != NULL) {    // Read line by line
    card_name = strtok(Buffer," \t\n");
    
     // Ignore empty lines, comments, and skip if card name does not match
    if (card_name==NULL || card_name[0]=='#' || strcmp(card_name, card_flag)!=0) continue;

    // Read numbers of given type (if MaxNum>1 read array)
    while ((card_val=strtok(NULL," \t\n")) != NULL && Count++<MaxNum) {
      switch (Type) {
	case 'I': *(((int *&) store)++) = (int) strtol(card_val, NULL, 10);
	      	  break;
	case 'i': *(((short *&) store)++) = (short) strtol(card_val, NULL, 10);
	      	  break;
	case 'U': *(((unsigned int *&) store)++) = (unsigned int) strtoul(card_val, NULL, 10);
	      	  break;
	case 'u': *(((unsigned short *&) store)++) = (unsigned short) strtoul(card_val, NULL, 10);
	      	  break;
	case 'f': *(((float *&) store)++) = atof(card_val);
	      	  break;
	case 'd': *(((double *&) store)++) = atof(card_val);
	      	  break;
	case 's': sprintf((char *) store, "%s", card_val);
	      	  break;
	case 'c': *((char *) store) = card_val[0];
	      	  break;
	default:  fprintf(stderr,"Warning: Unknown type '%c' for reading of configuration file\n", Type);
	      	  return false;
      }
    }
    return true;  // Finished reading data for card name  
  }
  return false;
}

