#ifndef MARS_MCorsikaRunHeader
#define MARS_MCorsikaRunHeader
///////////////////////////////////////////////////////////////////////
//                                                                   //
// MRunHeader                                                        //
//                                                                   //
///////////////////////////////////////////////////////////////////////

#ifndef MARS_MTime
#include "MTime.h"
#endif

class MCorsikaRunHeader : public MParContainer
{
    friend class MCorsikaEvtHeader;

private:
    UInt_t    fRunNumber;         // Run number
    UInt_t    fParticleID;        // Particle ID (see MMcEvtBasic or CORSIKA manual)
    UInt_t    fNumEvents;         // Number of events
    MTime     fRunStart;          // Date of begin (yymmdd)
    Float_t   fProgramVersion;    // Version of program

    Byte_t    fNumObsLevel;       // Number of observation levels
    Float_t   fObsLevel[10];      // Observation levels [cm]

    Float_t   fSlopeSpectrum;     // Slope of energy spectrum
    Float_t   fEnergyMin;         // Lower limit of energy range
    Float_t   fEnergyMax;         // Upper limit of energy range

    Float_t  fZdMin;                     // [rad] Zenith distance
    Float_t  fZdMax;                     // [rad] Zenith distance
    Float_t  fAzMin;                     // [rad] Azimuth (north=0; west=90)
    Float_t  fAzMax;                     // [rad] Azimuth (north=0; west=90)

    Float_t fWavelengthMin;      // [nm] Wavelength bandwidth lo edge
    Float_t fWavelengthMax;      // [nm] Wavelength bandwidth up edge

    //Float_t  fImpactMax;              // [cm] Maximum simulated impact

    Float_t fViewConeInnerAngle;      // [deg]
    Float_t fViewConeOuterAngle;      // [deg]

public:
    MCorsikaRunHeader(const char *name=NULL, const char *title=NULL);

    UInt_t GetFormatVersion() const { return (UInt_t)fProgramVersion; }
    Bool_t HasViewCone() const { return fViewConeOuterAngle>0; }

    Float_t GetZdMin() const { return fZdMin; }
    Float_t GetZdMax() const { return fZdMax; }

    Float_t GetAzMin() const { return fAzMin; }
    Float_t GetAzMax() const { return fAzMax; }

    Float_t GetWavelengthMin() const { return fWavelengthMin; }
    Float_t GetWavelengthMax() const { return fWavelengthMax; }

    UInt_t GetParticleID() const { return fParticleID; }

    //Float_t GetImpactMax() const { return fImpactMax; }

    Float_t GetViewConeOuterAngle() const { return fViewConeOuterAngle; }

    UInt_t GetNumEvents() const { return fNumEvents; }

    void Print(Option_t *t=NULL) const;

    Bool_t ReadEvt(istream& fin);
    Bool_t ReadEvtEnd(istream& fin);
    Bool_t SeekEvtEnd(istream &fin);

    ClassDef(MCorsikaRunHeader, 2)	// storage container for general info
};
#endif
