/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MViewAdcSpectra.h" 

#include <iostream.h>

#include "MParList.h"
#include "MTaskList.h"
#include "MEvtLoop.h"

#include "MRawRunHeader.h"
#include "MRawEvtHeader.h"
#include "MRawEvtData.h"
#include "MRawCrateArray.h"
#include "MTime.h"

#include "MReadTree.h" 
#include "MDumpEvtHeader.h" 
#include "MFillHFadc.h"
#include "MShowSpect.h" 
#include "MHFadcCam.h"

MViewAdcSpectra::MViewAdcSpectra() 
{
  // default constructor  
} 

MViewAdcSpectra::~MViewAdcSpectra() 
{
    // default destructor
    delete fHistosAdc;
} 


// ================================================================================
Bool_t MViewAdcSpectra::AdcSpectra ( Char_t *inputfile, Char_t *treeName ) 
{
  //   This job reads in the FADC data from all events and fills
  //   the spectrum for each pmt pixel.
  //

  cout << "PedAdcSpectra:: Analyse the tree " << treeName 
       << "in the file  " << inputfile << endl ;
  
  // create a (empty) list of parameters which can be used by the tasks
  // and an (empty) list of tasks which should be executed
  // connect them in the required way. 
 
  //
  //   create the data containers for the raw data
  //
  MParList plist;
  
  MRawRunHeader runheader;
  plist.AddToList(&runheader);

  MRawEvtHeader evtheader;
  plist.AddToList(&evtheader);
  
  MRawEvtData evtdata;
  plist.AddToList(&evtdata);
  
  MRawCrateArray cratearray;
  plist.AddToList(&cratearray);
  
  MTime evttime("MTime");
  plist.AddToList(&evttime);

  fHistosAdc= new MHFadcCam;
  plist.AddToList( fHistosAdc ) ;

  //
  //    set up the tasks for this job
  //
  MTaskList tasks;
  plist.AddToList(&tasks);

  MReadTree readin ( treeName, inputfile ) ;
  tasks.AddToList( &readin ) ;

  //  MDumpEvtHeader *dumpheader = new MDumpEvtHeader() ; 
  //  tasks->AddToList( dumpheader ) ; 
 
  MFillHFadc fillspect;
  tasks.AddToList( &fillspect ) ;

  MShowSpect showspect( "MHFadcCam" ) ;
  tasks.AddToList( &showspect ) ;

  //    set up the loop for the processing 
  
  MEvtLoop magic;
  magic.SetParList(&plist);

  //    start the loop running 

  magic.Eventloop() ; 
  
  return kTRUE ;

} 
