
#ifndef HVCONFIG_H_SEEN
#define HVCONFIG_H_SEEN

#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define MAX_COM_SIZE 1000
#define MAX_NUM_HVBOARDS 20
#define NUM_CHAINS 4
#define NUM_CHANNELS 32
#define BUFFER_LENGTH 256

#define MIN_TIMEOUT 0.01
#define MAX_TIMEOUT 5.0

#define MIN_RATE 0.01
#define MAX_RATE 50.0


class HVConfig {

 public:

  HVConfig(const char *);
  ~HVConfig();

  int NumHVBoards;
  int USBDeviceNumber[MAX_NUM_HVBOARDS];

  int fCCPort;

  bool TestMode;

  char   fLogFile[BUFFER_LENGTH];
  char   fSlowDir[BUFFER_LENGTH];
  char** fUSBDevice;

  char   fPixMapTable[BUFFER_LENGTH];
 
  float  fTimeOut;
  float  fStatusRefreshRate;

  int DACMin;
  int DACMax;

  float  fHVCalibOffset;
  float  fHVCalibSlope;
  
  unsigned int  fHVMaxDiff;
};

bool ReadCard(const char *, void *, char, FILE *, unsigned int=1);

#endif
