#include "MStargHistograms.h"

#include <iostream>
#include <iomanip>

#include <TSystem.h>
#include <TFile.h>
#include <TTree.h>
#include <TH1.h>
#include <TH2.h>
#include <TGraph.h>
#include <TCanvas.h>

#include "MTime.h"
#include "MPointing.h"

#include "Led.h"
#include "Leds.h"
#include "Ring.h"
#include "Rings.h"
#include "FilterLed.h"
#include "MStarList.h"

using namespace std;

void MStargHistograms::OpenFile()
{
        int i=0;
        char name[100];
        while (1)
        {
            sprintf(name, "data/starg%03d.root", i++);
            if (gSystem->AccessPathName(name, kFileExists))
                break;
        }

        if (fFile)
            delete fFile;

        fFile = new TFile(name, "RECREATE");

        if (!fFile->IsOpen())
        {
            delete fFile;
            fFile = NULL;

            cout << "Error: Cannot open file '" << name << "'" << endl;
        }

        TTree *tree = new TTree("Data", "Real Starg Data");


        fEvtTime = 0;


	// Tracking Position Zd, Az in deg
        tree->Branch("PosZd.",      &fZenithDist, "fZenithDist/D");
        tree->Branch("PosAz.",      &fAzimuth,    "fAzimuth/D");
	// Event time, arbitrary start
        tree->Branch("EvtTime.",    &fEvtTime,    "fEvtTime/D");
	// Pointing Position Zd, Az in deg
        tree->Branch("SaoZd.",      &fNomZd,      "fNomZd/D");
        tree->Branch("SaoAz.",      &fNomAz,     "fNomAz/D");
	// Misspointing from Starguider Zd, Az in deg
        tree->Branch("MisZd.",      &fdZd,        "fdZd/D");
        tree->Branch("MisAz.",      &fdAz,       "fdAz/D");
	// LED Offset from StargLEDFinder, obsolete
        tree->Branch("LEDOffsetX.", &fOffsetX,        "fOffsX/D");
        tree->Branch("LEDOffsetY.", &fOffsetY,       "fOffsY/D");
	// Center of Camera, offset from arb coords, in pix
        tree->Branch("CenterX.",    &fCenterX,        "fCenterX/D");
        tree->Branch("CenterY.",    &fCenterY,       "fCenterY/D");
	// number of spots found
        tree->Branch("Spots.",      &fSpots,       "fSpots/D");
	// number of stars expected
        tree->Branch("Stars.",      &fStars,       "fStars/D");
        tree->Branch("Bright.",      &fBright,       "fBright/D");

        cout << "Root file '" << name << "' open." << endl;
}

void MStargHistograms::CloseFile()
{
        if (!fFile)
            return;

        const TString  name = fFile->GetName();
        const Double_t n    = ((TTree*)fFile->Get("Data"))->GetEntries();

        fFile->Write();
        delete fFile;
        fFile = NULL;

        cout << "Root file closed (n=" << n << ")" << endl;

        if (n<1)
        {
            gSystem->Unlink(name);
            cout << "Root file deleted - no entries." << endl;
        }
}

void MStargHistograms::Fill(Leds &spots, MStarList &stars, ZdAz &d, ZdAz sao, Ring &center,  Double_t bright, const ZdAz &pos, const MTime &t)
{
      // FIXME!
      static const MTime t0(t);
      fEvtTime = t-t0;
    
      if (fFile && spots.GetEntries()>0)
      {
          fZenithDist = pos.Zd(); //fCosy ? fCosy->GetPointingPos().Zd() : 0
          fAzimuth    = pos.Az(); //fCosy ? fCosy->GetPointingPos().Az() : 0;
	  fNomZd      = sao.Zd();
	  fNomAz      = sao.Az();
	  fdZd        = d.Zd();
	  fdAz        = d.Az();

	  fCenterX    = center.GetX();
	  fCenterY    = center.GetY();
	  fStars      = stars.GetRealEntries();
	  fSpots      = spots.GetEntries();
	  fBright     = bright;

          TTree *t = (TTree*)fFile->Get("Data");
          t->Fill();
      }
}
