<?php
{
    function CreateQuery($_GET, $alias, $needs)
    {
        $joins = array
            (
             "fSourceName"                       => " LEFT JOIN Source USING(fSourceKEY) ",
            );

        $checkwhere = array
            (
             "fSourceName"                       => CheckWhere("fSourceKEY",                       $_GET),
            );
        $checkgroup = array
            (
             "fSourceName"                       => CheckGroup("fSourceKEY",                       $_GET),
            );

        $checkstatusgroup = array
            (
             "fAllFilesAvail"                    => CheckStatusGroup("fAllFilesAvailStatus",       $_GET),
             "fCallisto"                         => CheckStatusGroup("fCallistoStatus",            $_GET),
             "fFillCallisto"                     => CheckStatusGroup("fFillCallistoStatus",        $_GET),
             "fStar"                             => CheckStatusGroup("fStarStatus",                $_GET),
             "fFillStar"                         => CheckStatusGroup("fFillStarStatus",            $_GET),
            );

        $check = array
            (
             "fSourceName"                       => " Sequences.fSourceKEY",
            );

        $table = array
            (
             "fSourceName"                       => "Source.fSourceName",
             "fAllFilesAvail"                    => "SequenceProcessStatus.fAllFilesAvail",
             "fCallisto"                         => "SequenceProcessStatus.fCallisto",
             "fFillCallisto"                     => "SequenceProcessStatus.fFillCallisto",
             "fStar"                             => "SequenceProcessStatus.fStar",
             "fFillStar"                         => "SequenceProcessStatus.fFillStar",
             );

        $groups = 0;
        foreach ($checkgroup as $element)
            if ($element==-1)
                $groups++;

        $statusgroups = 0;
        foreach ($checkstatusgroup as $element)
            if ($element==-1)
                $statusgroups++;

        $query0 = "SELECT ";

        if ($groups>0)
        {
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                    $query0 .=  $key . " as '" . $alias[$key] . "' " . ", ";
            //--------------------------------------------------
            $query0 .= "SUM(fRunTime)/3600 as '" . $alias["SUM(fRunTime)/3600"] . "', ";
            //--------------------------------------------------
            $query0 .= " SUM(fNumEvents) as '" . $alias["SUM(fNumEvents)"] . "', ";
            $query0 .= " Min(fZenithDistanceMin) as '" . $alias["Min(fZenithDistanceMin)"] . "', ";
            $query0 .= " Max(fZenithDistanceMax) as '" . $alias["Max(fZenithDistanceMax)"] . "', ";
            $query0 .= " COUNT(*) as 'Sequence#' ";
        }
        else
        {
            if ($statusgroups>0)
            {
                foreach ($checkstatusgroup as $key => $element)
                    if ($element==-1)
                        $query0 .= " (if(IsNull(" . $key . "), if(isnull(fStartTime), 'not done', if(isnull(fFailedTime),if(isnull(" . $needs[$key] . "),'not done',if(date_sub(Now(),interval 12 hour) < fStartTime,'running','crashed')),if(isnull(" . $needs[$key] . "),'not done','failed'))) ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";
//                        $query0 .= " (if(IsNull(" . $key . "), 'not done' ,if(" . $key . "='1970-01-01 00:00:00','dont do','done'))) as '" . $alias[$key] . "', ";

                $query0 .= " count(*) as 'Sequence#'";

            }
            else
            {
                if (!empty($_GET["fSendTxt"]))
                    $query0 .= " Sequences.fSequenceFirst ";
                else
                    $query0 .= " CONCAT('<A&ws;HREF=\"runinfo.php?',  'fRunStart=On', '&fZenithDistance=On', '&fRunMin=', Sequences.fSequenceFirst, '&fMeanTriggerRate=On', '&fRunTypeName=On', '&fRunMax=', fSequenceLast, '&fNumEvents=On', '&fSourceName=On&', 'fExcludedFDAKEY=1', '&fSequenceFirst=On', '&fRawFileAvail=On', '&fCCFileAvail=On', '&fCaCoFileAvail=On\">', Sequences.fSequenceFirst, '</A>') ";
                $query0 .= " as 'Sequence#' ";

                foreach ($_GET as $key => $element)
                    if ($_GET[$key]=="On")
                        if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                            $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";
            }
        }

        $query0 .= " FROM Sequences ";

        $query0 .= " LEFT JOIN SequenceProcessStatus USING(fSequenceFirst,fTelescopeNumber) ";
        $query0 .= " LEFT JOIN Calibration USING(fSequenceFirst,fTelescopeNumber) ";
        $query0 .= " LEFT JOIN Star USING(fSequenceFirst,fTelescopeNumber) ";

        foreach ($_GET as $key => $element)
            if (($_GET[$key]=="On" || $groups>0) && !empty($joins[$key]))
                $query0 .= $joins[$key];

        foreach ($checkwhere as $key => $element)
        {
            if (empty($element) || $element<=0)
                continue;

            if (strpos($query0, " WHERE ")==FALSE)
                $query0 .= " WHERE ";
            else
                if ($element!=-1)
                    if (strrpos($query0, " AND ")!=strlen($query0)-5)
                        $query0 .= " AND ";

            if ($element!=-1)
                $query0 .= $check[$key] . "=" . $element;
        }

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= StatusQuery("fSequenceFileWritten", $needs, $timelimits);
        $query0 .= StatusQuery("fAllFilesAvail", $needs, $timelimits);
        $query0 .= StatusQuery("fCallisto", $needs, $timelimits);
        $query0 .= StatusQuery("fFillCallisto", $needs, $timelimits);
        $query0 .= StatusQuery("fStar", $needs, $timelimits);
        $query0 .= StatusQuery("fFillStar", $needs, $timelimits);

        if (!empty($_GET["fRunMin"]) && !empty($_GET["fRunMax"]))
            $query0 .= "Sequences.fSequenceFirst BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";
        else
            $query0 = substr($query0, 0, -6);

/*
        if (!empty($_GET["fDate"]))
            $query0 .= " AND fRunStart REGEXP \"^" . $_GET["fDate"] . "\" ";
*/

        if (!empty($_GET["fSourceN"]))
            $query0 .= " AND fSourceName REGEXP \"^" . $_GET["fSourceN"] . "\" ";

        if (!empty($_GET["fStartDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $startdate=substr($_GET["fStartDate"], 0, 10);
            if ($startdate=="0000-00-00")
                $query0 .=" fRunStart >= '" . $startdate . " 00:00:00' ";
            else
                $query0 .= " fRunStart >= ADDDATE('" . $startdate . " 13:00:00', INTERVAL -1 DAY) ";
        }

        if (!empty($_GET["fStopDate"]))
        {
            if (strpos(strrev($query0), " DNA ")!=0 || !strpos(strrev($query0), " DNA "))
                $query0 .= " AND ";

            $stopdate=substr($_GET["fStopDate"], 0, 10);
            $query0 .= " fRunStart < '" . $stopdate . " 13:00:00' ";
        }

        if ($groups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $groups;
            foreach ($checkgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= $check[$key];
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if ($statusgroups>0)
        {
            $query0 .= " GROUP BY ";
            $num = $statusgroups;
            foreach ($checkstatusgroup as $key => $element)
                if ($element==-1)
                {
                    $query0 .= $alias[$key];
                    if ($num-->1)
                        $query0 .= ", ";
                }
        }

        if (!empty($_GET["fSortBy"]))
        {
            $val=substr($_GET["fSortBy"], 0, -1);
            $query0 .= " ORDER BY " . GetTable($fromtable, $val) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fSortBy"]) && $groups==0 && $statusgroups==0)
            $query0 .= "ORDER BY Sequences.fSequenceFirst ASC ";

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        return $query0;
    }

    function InitGet($_GET)
    {
        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fSourceName"]))
            $_GET["fSourceName"]=$first?"On":"";

        if (empty($_GET["fAllFilesAvail"]))
            $_GET["fAllFilesAvail"]="On";

        if (empty($_GET["fAllFilesAvailStatus"]))
            $_GET["fAllFilesAvailStatus"]=$first?"7":"";

        if (empty($_GET["fCallisto"]))
            $_GET["fCallisto"]="On";

        if (empty($_GET["fCallistoStatus"]))
            $_GET["fCallistoStatus"]=$first?"7":"";

        if (empty($_GET["fFillCallisto"]))
            $_GET["fFillCallisto"]="Off";

        if (empty($_GET["fFillCallistoStatus"]))
            $_GET["fFillCallistoStatus"]="0";

        if (empty($_GET["fStar"]))
            $_GET["fStar"]=$first?"On":"";

        if (empty($_GET["fStarStatus"]))
            $_GET["fStarStatus"]=$first?"7":"";

        if (empty($_GET["fFillStar"]))
            $_GET["fFillStar"]="Off";

        if (empty($_GET["fFillStarStatus"]))
            $_GET["fFillStarStatus"]="0";
    }

    function PrintForm($_GET, $host, $user, $pw, $db)
    {
        printf("<center>\n");
        printf("<form action=\"dbstatus.php\" METHOD=\"GET\">\n");
        printf(" <table><tr><td>\n");

        PrintStatusMenu("fAllFilesAvail",       "Files avail");
        printf("  </td><td>\n");
        PrintStatusMenu("fCallisto",            "Callisto");
        printf("  </td><td>\n");
        PrintStatusMenu("fStar",                "Star");
        printf("  </td><td>\n");
        PrintStatusMenu("fFillCallisto",        "Fillcallisto");
        printf("  </td><td>\n");
        PrintStatusMenu("fFillStar",            "Fillstar");

        printf("</td></tr> </table>\n");
        printf(" <p>\n");

        // pull down boxes

        printf(" <table>\n");
        printf("  <tr><td>\n");
        PrintPullDown($host, $user, $pw, $db, "Source",      "fSourceName",      "fSourceKEY", "Source Name");
        printf("  </td><td>\n");

        printf("&nbsp;&nbsp;&nbsp;Source&nbsp;(<A HREF=\"regexp.html\">regexp</A>)&nbsp;<input name=\"fSourceN\" type=\"text\" size=\"15\" maxlength=\"15\" value=\"");
        if (!empty($_GET["fSourceN"]))
            printf("%s", $_GET["fSourceN"]);
        printf("\">&nbsp;&nbsp;&nbsp;\n");

        printf("  </td></tr>\n");
        printf(" </table>\n");
        printf(" <p>\n");

        if (empty($_GET["fStartDate"]))
            $timemin = GetMin("fRunStart", "Sequences", $host, $user, $pw, $db);
        else
            $timemin = $_GET["fStartDate"];

        if (empty($_GET["fStopDate"]))
            $timemax = GetMax("fRunStart", "Sequences", $host, $user, $pw, $db);
        else
            $timemax = $_GET["fStopDate"];

        printf("Night&nbsp;(yyyy-mm-dd)&nbsp;from&nbsp;<input name=\"fStartDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">\n", $timemin);
        printf("to&nbsp;<input name=\"fStopDate\" type=\"text\" size=\"10\" maxlength=\"10\" value=\"%s\">&nbsp;&nbsp;&nbsp;&nbsp;\n", $timemax);

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];

        printf("Sequences&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"dbstatus.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Print' onClick='self.location.href=\"%s&fPrintTable=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");
        printf("</td>\n");
        printf("</tr>\n");
        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $needs)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);

        $alias = array
            (
             "fSourceName"                      => "Source",
             "fAllFilesAvail"                   => "FilesAvail",
             "fCallisto"                        => "Callisto",
             "fStar"                            => "Star",
             "fFillCallisto"                    => "FillCal",
             "fFillStar"                        => "FillStar",
            );
        $rightalign = array
            (
            );

        $query0 = CreateQuery($_GET, $alias, $needs);

        $result0 = mysql_query($query0, $db_id);

        if ($result0)
        {
            if ($html=="1" || $html=="2")
                PrintMagicTable($result0, $alias, $rightalign, "", "", "", "", $_GET);
            else
                PrintText($result0);

            mysql_free_result($result0);
        }
        mysql_close($db_id);

        PrintSubmittedQuery($query0, $html, $db, "old");
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors", "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        if (empty($_GET["fPrintTable"]))
            PrintForm($_GET, $host, $user, $pw, $db);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
        {
            if (empty($_GET["fPrintTable"]))
                PrintPage("1", $host, $user, $pw, $db, $needs);
            else
                PrintPage("2", $host, $user, $pw, $db, $needs);
        }

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors", "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
