<?php
{
    function CreateQuery($_GET, $alias, $checkwhere)
    {
        $query0 = "SELECT SQL_CALC_FOUND_ROWS fSequenceFirst as 'Sequence#' ";

        foreach ($_GET as $key => $element)
            if ($_GET[$key]=="On")
                if (empty($checkwhere[$key]) || $checkwhere[$key]==0)
                    $query0 .= ", " . $key . " as '" . $alias[$key] . "' ";

        $query0 .= " FROM Calibration ";

        if (strpos($query0, " WHERE ")==FALSE)
            $query0 .= " WHERE ";
        else
            $query0 .= " AND ";

        $query0 .= "fSequenceFirst BETWEEN " . $_GET["fRunMin"] . " AND " . $_GET["fRunMax"] . " ";

        if (!empty($_GET["fSortBy"]))
        {
            $query0 .= " ORDER BY " . substr($_GET["fSortBy"], 0, -1) . " ";
            if (substr($_GET["fSortBy"], -1)=="-")
                $query0 .= "DESC";
        }

        if (empty($_GET["fNumStart"]))
            $_GET["fNumStart"]=0;

        if (empty($_GET["fSendTxt"]))
            $query0 .= " LIMIT " . $_GET["fNumStart"] . ", " . $_GET["fNumResults"];

        return $query0;
    }

    function InitGet($_GET)
    {
        // Find out whether it is the first call to the php script
        $first = empty($_GET["fRunMin"]) && empty($_GET["fRunMax"]);

        if (empty($_GET["fNumResults"]))
            $_GET["fNumResults"]="20";

        if (empty($_GET["fLastUpdate"]))
            $_GET["fLastUpdate"]="Off";

        if (empty($_GET["fUnreliableInner"]))
            $_GET["fUnreliableInner"]=$first?"On":"";

        if (empty($_GET["fUnsuitableOuter"]))
            $_GET["fUnsuitableOuter"]=$first?"On":"";

        if (empty($_GET["fUnsuitable50"]))
            $_GET["fUnsuitable50"]=$first?"On":"";

        if (empty($_GET["fUnsuitable01"]))
            $_GET["fUnsuitable01"]=$first?"On":"";

        if (empty($_GET["fUnsuitableMax"]))
            $_GET["fUnsuitableMax"]=$first?"On":"";

        if (empty($_GET["fDeadMax"]))
            $_GET["fDeadMax"]=$first?"On":"";

        if (empty($_GET["fUnreliableOuter"]))
            $_GET["fUnreliableOuter"]=$first?"On":"";

        if (empty($_GET["fUnsuitableInner"]))
            $_GET["fUnsuitableInner"]=$first?"On":"";

        if (empty($_GET["fIsolatedInner"]))
            $_GET["fIsolatedInner"]=$first?"On":"";

        if (empty($_GET["fIsolatedOuter"]))
            $_GET["fIsolatedOuter"]=$first?"On":"";

        if (empty($_GET["fMeanPedRmsInner"]))
            $_GET["fMeanPedRmsInner"]=$first?"On":"";

        if (empty($_GET["fMeanPedRmsOuter"]))
            $_GET["fMeanPedRmsOuter"]=$first?"On":"";

        if (empty($_GET["fIsolatedMaxCluster"]))
            $_GET["fIsolatedMaxCluster"]=$first?"On":"";

        if (empty($_GET["fArrTimeMeanInner"]))
            $_GET["fArrTimeMeanInner"]=$first?"On":"";

        if (empty($_GET["fArrTimeMeanOuter"]))
            $_GET["fArrTimeMeanOuter"]=$first?"On":"";

        if (empty($_GET["fArrTimeRmsInner"]))
            $_GET["fArrTimeRmsInner"]=$first?"On":"";

        if (empty($_GET["fArrTimeRmsOuter"]))
            $_GET["fArrTimeRmsOuter"]=$first?"On":"";

        if (empty($_GET["fMeanSignalInner"]))
            $_GET["fMeanSignalInner"]=$first?"Off":"";

        if (empty($_GET["fMeanSignalOuter"]))
            $_GET["fMeanSignalOuter"]=$first?"Off":"";

        if (empty($_GET["fPulsePosMean"]))
            $_GET["fPulsePosMean"]=$first?"Off":"";

        if (empty($_GET["fConvFactorInner"]))
            $_GET["fConvFactorInner"]=$first?"On":"";

        if (empty($_GET["fConvFactorOuter"]))
            $_GET["fConvFactorOuter"]=$first?"On":"";

    }

    function PrintForm($_GET, $host, $user, $pw, $db)
    {
        printf("<center>\n");
        printf("<form action=\"querycal.php\" METHOD=\"GET\">\n");
        printf(" <table>\n");
        printf("  <tr>\n");

        CheckBox("fUnsuitableInner",     "Unsuitable inner");
        CheckBox("fUnsuitableOuter",     "Unsuitable outer");
        CheckBox("fUnreliableInner",     "Unreliable inner");
        CheckBox("fUnreliableOuter",     "Unreliable outer");

        printf("  </tr><tr>\n");

        CheckBox("fUnsuitable50",        "Unsuitable (50%)");
        CheckBox("fUnsuitable01",        "Unsuitable (1%)");
        CheckBox("fUnsuitableMax",       "Unsuitable (99.9%)");
        CheckBox("fDeadMax",             "DeadMax");

        printf("  </tr><tr>\n");

        CheckBox("fIsolatedInner",       "Isolated inner");
        CheckBox("fIsolatedOuter",       "Isolated outer");

        printf("  </tr><tr>\n");

        CheckBox("fIsolatedMaxCluster",  "IsolatedMaxCluster");
        CheckBox("fArrTimeMeanInner",    "ArrTimeMean inner ");
        CheckBox("fArrTimeMeanOuter",    "ArrTimeMean outer ");
        CheckBox("fArrTimeRmsInner",     "ArrTimeRms inner ");
        CheckBox("fArrTimeRmsOuter",     "ArrTimeRms outer ");
        CheckBox("fPulsePosMean",        "Mean PulsePos");

        printf("  </tr><tr>\n");

        CheckBox("fConvFactorInner",     "Conv inner ");
        CheckBox("fConvFactorOuter",     "Conv outer ");
        CheckBox("fMeanPedRmsInner",     "MeanPedRms inner");
        CheckBox("fMeanPedRmsOuter",     "MeanPedRms outer");
        CheckBox("fMeanSignalInner",     "MeanSignal inner");
        CheckBox("fMeanSignalOuter",     "MeanSignal outer");

        printf(" </table>\n");
        printf(" <p>\n");

        if (empty($_GET["fRunMin"]))
            $min = GetMin("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $min = $_GET["fRunMin"];

        if (empty($_GET["fRunMax"]))
            $max = GetMax("fSequenceFirst", "Sequences", $host, $user, $pw, $db);
        else
            $max = $_GET["fRunMax"];


        printf("Sequences&nbsp;from&nbsp;<input name=\"fRunMin\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">\n", $min);
        printf("to&nbsp;<input name=\"fRunMax\" type=\"text\" size=\"6\" maxlength=\"6\" value=\"%s\">&nbsp;&nbsp;&nbsp;\n", $max);

        printf(" <P>\n");

        printf(" Results:\n");
        printf(" <select name=\"fNumResults\">\n");

        $numres = array("10", "20", "50", "100", "200", "500");
        foreach ($numres as $element)
        {
            if ($element==$_GET["fNumResults"])
                printf("<option value=\"%s\" selected>%3s</option>\n", $element, $element);
            else
                printf("<option value=\"%s\">%3s</option>\n", $element, $element);
        }
        printf(" </select>\n");
        printf(" &nbsp;&nbsp;&nbsp;\n");

        ini_set("mysql.trace_mode", "Off");
        ini_set("display_errors", "Off");

        printf("<input class='Width' type='submit' value='Query Table'>&nbsp;&nbsp;&nbsp;\n");
        printf("<input class='Width' type='button' value='Reset' onClick='self.location.href=\"querycal.php\"'>&nbsp;&nbsp;&nbsp;\n");
        if (strchr($_SERVER["REQUEST_URI"], '?')!=FALSE)
            printf("<input class='Width' type='button' value='Get .txt' onClick='self.location.href=\"%s&fSendTxt=1\"'>&nbsp;&nbsp;&nbsp;\n", $_SERVER["REQUEST_URI"]);
        printf("</form>\n");
        printf("</center>\n");
        printf("</td>\n");
        printf("</tr>\n");
        printf("<tr class='Block'>\n");
        printf("<td>\n");
    }

    function PrintPage($html, $host, $user, $pw, $db, $alias, $rightalign, $checkwhere)
    {
        $db_id = mysql_connect($host, $user, $pw);
        if ($db_id==FALSE)
        {
            printf("mysql_connect returned the following error: %s\n", mysql_error());
            die("");
        }
        mysql_select_db($db);

        $query0 = CreateQuery($_GET, $alias, $checkwhere);

        $result0 = mysql_query($query0, $db_id);
        $result1 = mysql_query("SELECT FOUND_ROWS()", $db_id);

        if ($result0)
        {
            if ($html=="1")
                PrintMagicTable($result0, $alias, $rightalign, "", "", "", "", $result1);
            else
                PrintText($result0);

            mysql_free_result($result0);
            mysql_free_result($result1);
        }
        mysql_close($db_id);

        PrintSubmittedQuery($query0, $html, $db, "old");
    }

    include ("include.php");
    include ("db.php");
    include ("magicdefs.php");

    ini_set("display_errors", "On");
    ini_set("mysql.trace_mode", "On");

    if (!empty($_GET["fSendTxt"]))
    {
        header("Content-type: application/octet");
        header("Content-Disposition: attachment; filename=query-result.txt");

        PrintPage("0", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere);
    }
    else
    {
        echo (file_get_contents("index-header.html"));

        $environment = sizeof($_GET);

        InitGet($_GET);
        PrintForm($_GET, $host, $user, $pw, $db);

        if ($environment==0)
            printf("No query submitted yet.<BR>");
        else
            PrintPage("1", $host, $user, $pw, $db, $alias, $rightalign, $checkwhere);

        echo (file_get_contents("index-footer.html"));
    }

    ini_set("display_errors", "Off");
    ini_set("mysql.trace_mode", "Off");
}
?>
