<?php

$needs = array
    (
     "fCCFilled"             => "SequenceBuildStatus.fDate",
     "fExclusionsDone"       => "fCCFilled",
     "fSequenceEntriesBuilt" => "fExclusionsDone",
     "fCCFileAvail"          => "RunProcessStatus.fRunNumber",
     "fCaCoFileAvail"        => "RunProcessStatus.fRunNumber",
     "fCaCoFileFound"        => "RunProcessStatus.fRunNumber",
     "fRawFileAvail"         => "RunProcessStatus.fRunNumber",
     "fDataCheckDone"        => "fRawFileAvail",
     "fTimingCorrection"     => "fRawFileAvail",
     "fSequenceFileWritten"  => "SequenceProcessStatus.fSequenceFirst",
     "fAllFilesAvail"        => "fSequenceFileWritten",
     "fCallisto"             => "fAllFilesAvail",
     "fStar"                 => "fCallisto",
     "fFillCallisto"         => "fCallisto",
     "fFillStar"             => "fStar",
     "fDataSetInserted"      => "DataSetProcessStatus.fDataSetNumber",
     "fDataSetFileWritten"   => "fDataSetInserted",
     "fStarFilesAvail"       => "fDataSetFileWritten",
     "fGanymed"              => "fStarFilesAvail",
     "fFillGanymed"          => "fGanymed",
     );


$timelimits = array();


$limitsmean = array
    (
     "fPedRmsInLimit"    => "fMeanPedRmsInner",
//     "fArrTRmsLimit"     => "fArrTimeRmsInner",
     "fMuonRateLimit"    => "fMuonRate",
     "fMuonCalLimit"     => "fRatio",
     "fPSFLimit"         => "fPSF",
     "fInhomLimit"       => "fInhomogeneity",
     "fNumIslLimit"      => "fMeanNumberIslands",
     "fImgRateLimit"     => "fDataRate",
     "fSkyBrightLimit"   => "fBrightnessMed",
    );

$limitsmin = array
    (
     "fZdMinLimit"       => "fZenithDistanceMin",
     "fNumStarsLimit"    => "fNumStarsMed",
     "fNumStarsCorLimit" => "fNumStarsCorMed",
     "fMuonNumLimit"     => "fMuonNumber",
//     "fArrTimeLimit"     => "fArrTimeInner",
     "fPulsePosLimit"    => "fMeanPulsePosInner",
     "fRunTimeLimit"     => "fRunTime/60",
     "fRelTimeMinLimit"  => "fEffOnTime/fRunTime",
    );

$limitsmax = array
    (
     "fZdMaxLimit"       => "fZenithDistanceMax",
     "fUnsInLimit"       => "fUnsuitableInner",
     "fIsoInLimit"       => "fIsolatedInner",
     "fIMCLimit"         => "fIsolatedMaxCluster",
     "fMaxHumLimit"      => "fMaxHumidity",
     "fRelTimeMaxLimit"  => "fEffOnTime/fRunTime",
    );

$checkwhere = array
    (
     "fRunTypeName"                      => CheckWhere("fRunTypeKEY"),
     "fProjectName"                      => CheckWhere("fProjectKEY"),
     "fSourceName"                       => CheckWhere("fSourceKEY"),
     "fMagicNumberName"                  => CheckWhere("fMagicNumberKEY"),
     "fL1TriggerTableName"               => CheckWhere("fL1TriggerTableKEY"),
     "fL2TriggerTableName"               => CheckWhere("fL2TriggerTableKEY"),
     "fL3TriggerTableName"               => CheckWhere("fL3TriggerTableKEY"),
     "fHvSettingsName"                   => CheckWhere("fHvSettingsKEY"),
     "fCalibrationScriptName"            => CheckWhere("fCalibrationScriptKEY"),
     "fExcludedFDAName"                  => CheckWhere("fExcludedFDAKEY"),
     "fManuallyChangedName"              => CheckWhere("fManuallyChangedKEY"),
     "fObservationModeName"              => CheckWhere("fObservationModeKEY"),
     "fSumTriggerFlagName"               => CheckWhere("fSumTriggerFlagKEY"),
     "fDiscriminatorThresholdTableName"  => CheckWhere("fDiscriminatorThresholdTableKEY"),
     "fTriggerDelayTableName"            => CheckWhere("fTriggerDelayTableKEY"),
     "fTestFlagName"                     => CheckWhere("fTestFlagKEY"),
     "fLightConditionsName"              => CheckWhere("fLightConditionsKEY"),
     "fParticleTypeName"                 => CheckWhere("fParticleTypeKEY"),
     "fFitsFileName"                     => CheckWhere("fFitsFileKEY"),
     "fObjectName"                       => CheckWhere("fObjectKEY"),
     "fStatusName"                       => CheckWhere("fStatusKEY"),
     "fTelescopeName"                    => CheckWhere("fTelescopeKEY"),
     "fBandName"                         => CheckWhere("fBandKEY"),
     "fUserName"                         => CheckWhere("fUserKEY"),
     "fCycleName"                        => CheckWhere("fCycleKEY"),
     "fPIName"                           => CheckWhere("fPIKEY"),
     "fWorkingGroupName"                 => CheckWhere("fWorkingGroupKEY"),
     "fProposalName"                     => CheckWhere("fProposalKEY"),
    );

$checkgroup = array
    (
     "fRunTypeName"                      => CheckGroup("fRunTypeKEY"),
     "fProjectName"                      => CheckGroup("fProjectKEY"),
     "fSourceName"                       => CheckGroup("fSourceKEY"),
     "fMagicNumberName"                  => CheckGroup("fMagicNumberKEY"),
     "fL1TriggerTableName"               => CheckGroup("fL1TriggerTableKEY"),
     "fL2TriggerTableName"               => CheckGroup("fL2TriggerTableKEY"),
     "fL3TriggerTableName"               => CheckGroup("fL3TriggerTableKEY"),
     "fHvSettingsName"                   => CheckGroup("fHvSettingsKEY"),
     "fCalibrationScriptName"            => CheckGroup("fCalibrationScriptKEY"),
     "fExcludedFDAName"                  => CheckGroup("fExcludedFDAKEY"),
     "fManuallyChangedName"              => CheckGroup("fManuallyChangedKEY"),
     "fObservationModeName"              => CheckGroup("fObservationModeKEY"),
     "fSumTriggerFlagName"               => CheckGroup("fSumTriggerFlagKEY"),
     "fDiscriminatorThresholdTableName"  => CheckGroup("fDiscriminatorThresholdTableKEY"),
     "fTriggerDelayTableName"            => CheckGroup("fTriggerDelayTableKEY"),
     "fTestFlagName"                     => CheckGroup("fTestFlagKEY"),
     "fLightConditionsName"              => CheckGroup("fLightConditionsKEY"),
     "fParticleTypeName"                 => CheckGroup("fParticleTypeKEY"),
     "fFitsFileName"                     => CheckGroup("fFitsFileKEY"),
     "fObjectName"                       => CheckGroup("fObjectKEY"),
     "fStatusName"                       => CheckGroup("fStatusKEY"),
     "fBandName"                         => CheckGroup("fBandKEY"),
     "fUserName"                         => CheckGroup("fUserKEY"),
     "fTelescopeName"                    => CheckGroup("fTelescopeKEY"),
     "fCycleName"                        => CheckWhere("fCycleKEY"),
     "fPIName"                           => CheckWhere("fPIKEY"),
     "fWorkingGroupName"                 => CheckWhere("fWorkingGroupKEY"),
     "fProposalName"                     => CheckWhere("fProposalKEY"),
    );


$checkstatusgroup = array
    (
     "fCCFilled"                         => CheckStatusGroup("fCCFilledStatus"),
     "fExclusionsDone"                   => CheckStatusGroup("fExclusionsDoneStatus"),
     "fSequenceEntriesBuilt"             => CheckStatusGroup("fSequenceEntriesBuiltStatus"),
     "fCCFileAvail"                      => CheckStatusGroup("fCCFileAvailStatus"),
     "fCaCoFileAvail"                    => CheckStatusGroup("fCaCoFileAvailStatus"),
     "fCaCoFileFound"                    => CheckStatusGroup("fCaCoFileFoundStatus"),
     "fRawFileAvail"                     => CheckStatusGroup("fRawFileAvailStatus"),
     "fTimingCorrection"                 => CheckStatusGroup("fTimingCorrectionStatus"),
     "fDataCheckDone"                    => CheckStatusGroup("fDataCheckDoneStatus"),
//     "fFillDotRaw"                       => CheckStatusGroup("fFillDotRawStatus"),
     "fSequenceFileWritten"              => CheckStatusGroup("fSequenceFileWrittenStatus"),
     "fAllFilesAvail"                    => CheckStatusGroup("fAllFilesAvailStatus"),
     "fCallisto"                         => CheckStatusGroup("fCallistoStatus"),
     "fFillCallisto"                     => CheckStatusGroup("fFillCallistoStatus"),
     "fStar"                             => CheckStatusGroup("fStarStatus"),
     "fFillStar"                         => CheckStatusGroup("fFillStarStatus"),
     "fDataSetInserted"                  => CheckStatusGroup("fDataSetInsertedStatus"),
     "fDataSetFileWritten"               => CheckStatusGroup("fDataSetFileWrittenStatus"),
     "fStarFilesAvail"                   => CheckStatusGroup("fStarFilesAvailStatus"),
     "fGanymed"                          => CheckStatusGroup("fGanymedStatus"),
     "fFillGanymed"                      => CheckStatusGroup("fFillGanymedStatus"),
    );


$checkenumgroup = array
    (
     "fHasSignal"              => CheckEnumGroup("fHasSignalEnum"),
     "fHasPedestal"            => CheckEnumGroup("fHasPedestalEnum"),
     "fHasSignalInterlaced"    => CheckEnumGroup("fHasSignalInterlacedEnum"),
     "fHasPedestalInterlaced"  => CheckEnumGroup("fHasPedestalInterlacedEnum"),
    );



$alias = array
    (
     "fRawFileKEY"                      => "Idx",
     "fMagicNumberName"                 => "Magic#",
     "fFormatVersion"                   => "F-Ver",
     "fLastUpdate"                      => "LastUpd",
//     "fRunNumber"                       => "Run#",
     "Run#"                       => "Run#",
     "Tel:Run:File"                       => "Tel:Run:File",
     "fRunTypeName"                     => "RunType",
     "fMeanTriggerRate"                 => "Rate<br>[Hz]",
     "fDaqTriggerRate"                  => "Daq<br>TRate<br>[Hz]",
     "fDaqStoreRate"                    => "Daq<br>SRate<br>[Hz]",
     "fL2RatePresc"                     => "L2<br>pRate<br>[Hz]",
     "fL3TriggerRate"                   => "L3<br>TRate<br>[Hz]",
     "fL2RateUnpresc"                   => "L2<br>upRate<br>[Hz]",
     "fManuallyChangedName"             => "Manually<br>Changed",
     "fObservationModeName"             => "Obs.<br>Mode",
     "fSumTriggerFlagName"              => "SumTrigger<br>Flag",
     "fLastUpdate"                      => "LastUpd",
     "fSequenceFirst"                   => "Sequ",
     "fProjectName"                     => "Project",
     "fSourceName"                      => "Source",
     "fNumEvents"                       => "#Evts",
     "fRunTime/60"                      => "Up<br>Time<br>[min]",
     "fRunStart"                        => "Start",
     "fRunStop"                         => "Stop",
//     "fRunStart"                        => "StartTime",
     "fSequenceLast"                    => "Last<br>Run",
     "fL1TriggerTableName"              => "L1Trig<br>Table",
     "fL2TriggerTableName"              => "L2Trig<br>Table",
     "fL3TriggerTableName"              => "L3Trig<br>Table",
     "fHvSettingsName"                  => "HV Settings",
     "fCalibrationScriptName"           => "Cal Script",
     "fTestFlagName"                    => "Testflag",
     "fLightConditionsName"             => "Lightcond",
     "fTriggerDelayTableName"           => "TrigDelay",
     "fDiscriminatorThresholdTableName" => "DT",
     "fExcludedFDAName"                 => "Exclusion",
     "fCycleName"                       => "Cycle",
     "fPIName"                          => "PI name",
     "fWorkingGroupName"                => "Working<br>Group",
     "fProposalName"                    => "Proposal",
     "fWheelPos1"                       => "Wheel<br>Pos 1",
     "fWheelPos2"                       => "Wheel<br>Pos 2",
     "fZenithDistance"                  => "Zd",
     "fAzimuth"                         => "Az",
     "fZenithDistanceMin"               => "Zd<br>Min",
     "fZenithDistanceMax"               => "Zd<br>Max",
     "fAzimuthMin"                      => "Az<br>Min",
     "fAzimuthMax"                      => "Az<br>Max",
     "fTest"                            => "Test",
     "fSourceKEY"                       => "KEY",
     "fDate"                            => "Date",
     "fCCFilled"                        => "CCFilled",
     "fExclusionsDone"                  => "Exclusions",
     "fSequenceEntriesBuilt"            => "Sequences",
     "fCCFileAvail"                     => "CCFile",
     "fCaCoFileAvail"                   => "CaCoFile",
     "fCaCoFileFound"                   => "CaCoRun",
     "fRawFileAvail"                    => "RawFile",
     "fTimingCorrection"                => "TimingCorr",
     "fDataCheckDone"                   => "Datacheck",
//     "fFillDotRaw"                      => "Filldotraw",
     "fSequenceFileWritten"             => "SequFile",
     "fAllFilesAvail"                   => "FilesAvail",
     "fCallisto"                        => "Callisto",
     "fStar"                            => "Star",
     "fFillCallisto"                    => "FillCal",
     "fFillStar"                        => "FillStar",
     "fDataSetInserted"                 => "DataSet",
     "fDataSetFileWritten"              => "DataSetFile",
     "fStarFilesAvail"                  => "FilesAvail",
     "fGanymed"                         => "Ganymed",
     "fFillGanymed"                     => "FillGanymed",
     "fUnsuitableOuter"                 => "Un<br>suit.<br>Out",
     "fUnreliableOuter"                 => "Un<br>rel.<br>Out",
     "fUnreliableInner"                 => "Un<br>rel.<br>In",
     "fUnsuitableInner"                 => "Un<br>suit.<br>In",
     "fUnsuitable50"                    => "Un<br>suit.<br>50",
     "fUnsuitable01"                    => "Un<br>suit.<br>01",
     "fUnsuitableMax"                   => "Un<br>suit.<br>Max",
     "fDeadMax"                         => "Dead<br>Max",
     "fRateTrigEvts"                    => "Rate Trig.<br>Evts [Hz]",
     "fRateSumEvts"                     => "Rate Sum<br>Evts [Hz]",
     "fRatePedEvts"                     => "Rate Ped<br>Evts [Hz]",
     "fRatePedTrigEvts"                 => "Rate Ped.Trig.<br>Evts [Hz]",
     "fRateCalEvts"                     => "Rate Cal.<br>Evts [Hz]",
     "fRateNullEvts"                    => "Rate Null<br>Evts [Hz]",
     "fRateUnknownEvts"                 => "Rate Unknown<br>Evts [Hz]",
     "fRatioCalEvents"                  => "Ratio Cal.<br>Events",
     "fPulsePosCalib"                   => "Pulse Pos.<br>Calib",
     "fIsolatedOuter"                   => "Isol.<br>Out",
     "fIsolatedInner"                   => "Isol.<br>In",
     "fMeanPedRmsOuter"                 => "Ped<br>Rms<br>Out",
     "fMeanPedRmsInner"                 => "Ped<br>Rms<br>In",
     "fArrTimeMeanInner"                => "Arr<br>Time<br>In",
     "fArrTimeMeanOuter"                => "Arr<br>Time<br>Out",
     "fArrTimeRmsInner"                 => "Rms<br>ArrT<br>In",
     "fArrTimeRmsOuter"                 => "Rms<br>ArrT<br>Out",
     "fMeanSignalInner"                 => "Sign<br>In",
     "fMeanSignalOuter"                 => "Sign<br>Out",
     "fMeanPulsePosInner"               => "Pulse<br>PosIn",
     "fPulsePosMean"                    => "Puls<br>Pos",
     "fConvFactorInner"                 => "Conv<br>In",
     "fConvFactorOuter"                 => "Conv<br>Out",
     //             "fConvFactorInner"                 => "Conv Inner<BR>[ph/FADC]",
     //             "fConvFactorOuter"                 => "Conv Outer<BR>[ph/FADC]",
     "fIsolatedMaxCluster"              => "Isol.<br>Max<br>Cl",
     "fMeanNumberIslands"               => "Mean<br>Num<br>Isl",
     "fPSF"                             => "PSF<br>[mm]",
     "fRatio"                           => "Ratio<br>[%]",
     "fMuonNumber"                      => "#<br>Muons",
     "fEffOnTime"                       => "EffOn<br>Time<br>[s]",
     "fEffOnTime/fRunTime"              => "RelOn<br>Time",
     "fEffOnTime/3600"                  => "EffOn<br>Time<br>[h]",
     "fMuonRate"                        => "Muon<br>Rate<br>[Hz]",
     "fInhomogeneity"                   => "Inhom",
     "fDataRate"                        => "Img.<br>Rate<br>[Hz]",
     "fSparkRate"                       => "Spark<br>Rate<br>[Hz]",
     "fMaxHumidity"                     => "Max<br>Hum<br>[%]",
     "fBrightnessMed"                   => "Sky<br>Brightn.<br>Med",
     "fBrightnessRMS"                   => "Sky<br>Brightn.<br>RMS",
     "fNumStarsMed"                     => "#<br>id.<br>stars",
     "fNumStarsRMS"                     => "RMS<br>id.<br>stars",
     "fNumStarsCorMed"                  => "#<br>cor.<br>stars",
     "fNumStarsCorRMS"                  => "RMS<br>cor.<br>stars",
     "fAvgWindSpeed"                    => "Avg. wind<br>speed [m/s]",
     "fAvgTemperature"                  => "Avg. temp.<br>[deg]",
     "fAvgHumidity"                     => "Avg. hum.<br>[%]",
     "fAvgTempSky"                      => "Avg. sky<br>temp [deg]",
     "fAvgCloudiness"                   => "Avg. cloud.<br>[%]",
     "fRmsCloudiness"                   => "RMS cloud.<br>[%]",
     "fEvents"                          => "DataEvents",
     "fPositionSignal"                  => "ArrTime",
     "fPositionFWHM"                    => "ArrTimeFWHM",
     "fHeightSignal"                    => "Signal",
     "fHeightFWHM"                      => "SignalFWHM",
     "fHasSignal"                       => "HasSignal",
     "fHasPedestal"                     => "HasPedestal",
     "fPositionAsym"                    => "ArrTimeAsym",
     "fHeightAsym"                      => "SignalAsym",
     "fEventsInterlaced"                => "CalEvents",
     "fPositionSignalInterlaced"        => "ArrTimeCal",
     "fPositionFWHMInterlaced"          => "ArrTimeFWHMCal",
     "fHeightSignalInterlaced"          => "SignalCal",
     "fHeightFWHMInterlaced"            => "SignalFWHMCal",
     "fHasSignalInterlaced"             => "HasSignalCal",
     "fHasPedestalInterlaced"           => "HasPedestalCal",
     "fPositionAsymInterlaced"          => "ArrTimeAsymCal",
     "fHeightAsymInterlaced"            => "SignalAsymCal",
     "fExcessEvents"                    => "Exc<br>Evts",
     "fBackgroundEvents"                => "Bg<br>Evts",
     "fSignalEvents"                    => "Sign<br>Evts",
     "fSignificance"                    => "Sign",
     "fScaleFactor"                     => "Scale",
     "fDataSetNumber"                   => "Data<br>Set#",
     "fComment"                         => "Comment",
     "fUserName"                        => "User",
     "fRunTime"                         => "Up<br>Time<br>[min]",
     "fDataSetName"                     => "Name",
     "fExcessEvents*60/fEffOnTime"      => "Exc<br>Rate",
     "fBackgroundEvents*60/fEffOnTime"  => "Bg<br>Rate",
     "fSignalEvents*60/fEffOnTime"      => "Sign<br>Rate",
     "Round(fSignificance/Sqrt(fEffOnTime/3600),2)" => "Signf<br>Rate",
     "SUM(fRunTime)/3600"               => "Time [h]",
     "SUM(fNumEvents)"                  => "Evts",
     "Min(fZenithDistanceMin)"          => "ZDMin",
     "Max(fZenithDistanceMax)"          => "ZDMax",
     "Min(fZenithDistance)"             => "ZdMin",
     "Max(fZenithDistance)"             => "ZdMax",
//     "fArrTimeLimit"                    => "ArrTRms",
//     "fArrTimeLimit"                    => "ArrTime",
     "fPulsePosLimit"                   => "PulsePos",
     "fRunTimeLimit"                    => "UpTime",
     "fPedRmsInLimit"                   => "PedRms",
     "fMuonRateLimit"                   => "MuonRate",
     "fMuonNumLimit"                    => "# Muons",
     "fMuonCalLimit"                    => "MuonCal",
     "fPSFLimit"                        => "PSF",
     "fInhomLimit"                      => "Inhom.",
     "fNumIslLimit"                     => "# Islands",
     "fImgRateLimit"                    => "ImgRate",
     "fSkyBrightLimit"                  => "SkyBrightness",
     "fNumStarsLimit"                   => "# id. Stars",
     "fNumStarsCorLimit"                => "# cor. Stars",
     "fUnsInLimit"                      => "Unsuit.In",
     "fIsoInLimit"                      => "Isol.In",
     "fIMCLimit"                        => "IMC",
     "fMaxHumLimit"                     => "Humidity",
     "fZdMinLimit"                      => "ZdMin",
     "fZdMaxLimit"                      => "ZdMax",
     "fRelTimeMaxLimit"                 => "Rel.Ontime",
     "fRelTimeMinLimit"                 => "Rel.Ontime",
     "fEMin"                            => "Emin",
     "fEMax"                            => "Emax",
     "fParticleTypeName"                => "Particle",
     "fStartTime"                       => "Process",
     "fFailedTime"                      => "Failed",
     "fReturnCode"                      => "Ret<br>Code",
     "fProgramId"                       => "Prgr<br>Id",
     "fTimestamp"                       => "Time",
     "fExposure"                        => "Exposure",
     "fFitsFileName"                    => "FitsFile",
     "fObjectName"                      => "Object",
     "fSkyLevel"                        => "SkyLevel",
     "fFWHM"                            => "FWHM",
     "fApertureRadius"                  => "Ap.Rad.",
     "fInstrumentalMag"                 => "Instr.Mag.",
     "fInstrumentalMagErr"              => "Instr.Mag.Err.",
     "fStatusName"                      => "StatusCode",
     "fTelescopeName"                   => "Telescope",
     "fBandName"                        => "Band",
//     "COUNT(*)"                         => "# Runs",
//     "COUNT(*)"                         => "Sequence",
    );


$rightalign = array
    (
     $alias["fRawFileKEY"]               => "1",
     $alias["fFormatVersion"]            => "1",
//     $alias["fRunNumber"]                => "1",
     $alias["fZenithDistance"]           => "1",
     $alias["fAzimuth"]                  => "1",
     $alias["fMeanTriggerRate"]          => "1",
     $alias["fDaqTriggerRate"]           => "1",
     $alias["fDaqStoreRate"]             => "1",
     $alias["fL2RatePresc"]              => "1",
     $alias["fL3TriggerRate"]            => "1",
     $alias["fL2RateUnpresc"]            => "1",
     $alias["fSequenceFirst"]            => "1",
     $alias["fNumEvents"]                => "1",
     $alias["fRunTime/60"]               => "1",
     $alias["fSequenceLast"]             => "1",
     $alias["fZenithDistanceMin"]        => "1",
     $alias["fZenithDistanceMax"]        => "1",
     $alias["fWheelPos1"]                => "1",
     $alias["fWheelPos2"]                => "1",
     $alias["fAzimuthMin"]               => "1",
     $alias["fAzimuthMax"]               => "1",
     $alias["fUnsuitableOuter"]          => "1",
     $alias["fUnreliableOuter"]          => "1",
     $alias["fUnsuitableInner"]          => "1",
     $alias["fUnreliableInner"]          => "1",
     $alias["fUnsuitable50"]             => "1",
     $alias["fUnsuitable01"]             => "1",
     $alias["fUnsuitableMax"]            => "1",
     $alias["fDeadMax"]                  => "1",
     $alias["fRateTrigEvts"]             => "1",
     $alias["fRateSumEvts"]              => "1",
     $alias["fRatePedEvts"]              => "1",
     $alias["fRatePedTrigEvts"]          => "1",
     $alias["fRateCalEvts"]              => "1",
     $alias["fRateNullEvts"]             => "1",
     $alias["fRateUnknownEvts"]          => "1",
     $alias["fRatioCalEvents"]           => "1",
     $alias["fPulsePosCalib"]            => "1",
     $alias["fIsolatedOuter"]            => "1",
     $alias["fIsolatedInner"]            => "1",
     $alias["fMeanPedRmsOuter"]          => "1",
     $alias["fMeanPedRmsInner"]          => "1",
     $alias["fArrTimeMeanInner"]         => "1",
     $alias["fArrTimeMeanOuter"]         => "1",
     $alias["fArrTimeRmsInner"]          => "1",
     $alias["fArrTimeRmsOuter"]          => "1",
     $alias["fMeanSignalInner"]          => "1",
     $alias["fMeanSignalOuter"]          => "1",
     $alias["fPulsePosMean"]             => "1",
     $alias["fConvFactorInner"]          => "1",
     $alias["fConvFactorOuter"]          => "1",
     $alias["fIsolatedMaxCluster"]       => "1",
     $alias["fMeanNumberIslands"]        => "1",
     $alias["fPSF"]                      => "1",
     $alias["fRatio"]                    => "1",
     $alias["fMuonNumber"]               => "1",
     $alias["fEffOnTime"]                => "1",
     $alias["fEffOnTime/fRunTime"]       => "1",
     $alias["fEffOnTime/3600"]           => "1",
     $alias["fMuonRate"]                 => "1",
     $alias["fInhomogeneity"]            => "1",
     $alias["fDataRate"]                 => "1",
     $alias["fSparkRate"]                => "1",
     $alias["fMaxHumidity"]              => "1",
     $alias["fBrightnessMed"]            => "1",
     $alias["fBrightnessRMS"]            => "1",
     $alias["fNumStarsMed"]              => "1",
     $alias["fNumStarsRMS"]              => "1",
     $alias["fNumStarsCorMed"]           => "1",
     $alias["fNumStarsCorRMS"]           => "1",
     $alias["fAvgWindSpeed"]             => "1",
     $alias["fAvgTemperature"]           => "1",
     $alias["fAvgHumidity"]              => "1",
     $alias["fAvgTempSky"]               => "1",
     $alias["fAvgCloudiness"]            => "1",
     $alias["fRmsCloudiness"]            => "1",
     $alias["fDate"]                     => "1",
     $alias["fCaCoFileFound"]            => "1",
     $alias["fTest"]                     => "1",
     $alias["fSourceKEY"]                => "1",
     $alias["fEvents"]                   => "1",
     $alias["fPositionSignal"]           => "1",
     $alias["fPositionFWHM"]             => "1",
     $alias["fHeightSignal"]             => "1",
     $alias["fHeightFWHM"]               => "1",
     $alias["fHasSignal"]                => "1",
     $alias["fHasPedestal"]              => "1",
     $alias["fPositionAsym"]             => "1",
     $alias["fHeightAsym"]               => "1",
     $alias["fEventsInterlaced"]         => "1",
     $alias["fPositionSignalInterlaced"] => "1",
     $alias["fPositionFWHMInterlaced"]   => "1",
     $alias["fHeightSignalInterlaced"]   => "1",
     $alias["fHeightFWHMInterlaced"]     => "1",
     $alias["fHasSignalInterlaced"]      => "1",
     $alias["fHasPedestalInterlaced"]    => "1",
     $alias["fPositionAsymInterlaced"]   => "1",
     $alias["fHeightAsymInterlaced"]     => "1",
     $alias["fReturnCode"]               => "1",
     $alias["fProgramId"]                => "1",
     "Time"                              => "1",
//     "Time [h]"                 => "1",
     "ZDMin"                             => "1",
     "ZDMax"                             => "1",
//     "Evts#"                    => "1",
//     "Runs#"                    => "1"
     "Runs"                              => "1",
     "Evts"                              => "1",
);

function GetCheck($fromtable, $val)
{
    $checks = array
        (
         "fRunTypeName"                      => $fromtable . ".fRunTypeKEY",
         "fProjectName"                      => $fromtable . ".fProjectKEY",
         "fSourceName"                       => $fromtable . ".fSourceKEY",
         "fMagicNumberName"                  => $fromtable . ".fMagicNumberKEY",
         "fL1TriggerTableName"               => $fromtable . ".fL1TriggerTableKEY",
         "fL2TriggerTableName"               => $fromtable . ".fL2TriggerTableKEY",
         "fL3TriggerTableName"               => $fromtable . ".fL3TriggerTableKEY",
         "fHvSettingsName"                   => $fromtable . ".fHvSettingsKEY",
         "fCalibrationScriptName"            => $fromtable . ".fCalibrationScriptKEY",
         "fExcludedFDAName"                  => $fromtable . ".fExcludedFDAKEY",
         "fManuallyChangedName"              => $fromtable . ".fManuallyChangedKEY",
         "fObservationModeName"              => $fromtable . ".fObservationModeKEY",
         "fSumTriggerFlagName"               => $fromtable . ".fSumTriggerFlagKEY",
         "fDiscriminatorThresholdTableName"  => $fromtable . ".fDiscriminatorThresholdTableKEY",
         "fTriggerDelayTableName"            => $fromtable . ".fTriggerDelayTableKEY",
         "fTestFlagName"                     => $fromtable . ".fTestFlagKEY",
         "fLightConditionsName"              => $fromtable . ".fLightConditionsKEY",
         "fParticleTypeName"                 => $fromtable . ".fParticleTypeKEY",
         "fFitsFileName"                     => $fromtable . ".fFitsFileKEY",
         "fObjectName"                       => $fromtable . ".fObjectKEY",
         "fStatusName"                       => $fromtable . ".fStatusKEY",
         "fBandName"                         => $fromtable . ".fBandKEY",
         "fUserName"                         => $fromtable . ".fUserKEY",
         "fTelescopeName"                    => $fromtable . ".fTelescopeKEY",
         "fCycleName"                        => $fromtable . ".fCycleKEY",
         "fPIName"                           => $fromtable . ".fPIKEY",
         "fWorkingGroupName"                 => $fromtable . ".fWorkingGroupKEY",
         "fProposalName"                     => $fromtable . ".fProposalKEY",
        );

    $check="";
    if (!empty($checks[$val]))
        $check=$checks[$val];
    return $check;
}


function GetTable($fromtable, $val)
{
    $tables = array
        (
         "fSequenceFirst"                    => $fromtable . ".fSequenceFirst",
         "fSequenceLast"                     => $fromtable . ".fSequenceLast",
         "fNumEvents"                        => $fromtable . ".fNumEvents",
         "fRunStart"                         => $fromtable . ".fRunStart",
         "fLastUpdate"                       => $fromtable . ".fLastUpdate",
         "fRunTime"                          => $fromtable . ".fRunTime",
         "fRunTime/60"                       => $fromtable . ".fRunTime/60",
         "fAzimuthMin"                       => $fromtable . ".fAzimuthMin",
         "fAzimuthMax"                       => $fromtable . ".fAzimuthMax",
         "fZenithDistanceMin"                => $fromtable . ".fZenithDistanceMin",
         "fZenithDistanceMax"                => $fromtable . ".fZenithDistanceMax",
         "fRunNumber"                        => "RunData.fRunNumber",
         "fRunStop"                          => "RunData.fRunStop",
         "fAzimuth"                          => "RunData.fAzimuth",
         "fZenithDistance"                   => "RunData.fZenithDistance",
         "fFormatVersion"                    => "RunData.fFormatVersion",
         "fRunTypeName"                      => "RunType.fRunTypeName",
         "fDaqStoreRate"                     => "RunData.fDaqStoreRate",
         "fDaqTriggerRate"                   => "RunData.fDaqTriggerRate",
         "fMeanTriggerRate"                  => "RunData.fMeanTriggerRate",
         "fL2RatePresc"                      => "RunData.fL2RatePresc",
         "fL3TriggerRate"                    => "RunData.fL3TriggerRate",
         "fL2RateUnpresc"                    => "RunData.fL2RateUnpresc",
         "fMagicNumberName"                  => "MagicNumber.fMagicNumberName",
         "fExcludedFDAName"                  => "ExcludedFDA.fExcludedFDAName",
         "fProjectName"                      => "Project.fProjectName",
         "fSourceName"                       => "Source.fSourceName",
         "fL1TriggerTableName"               => "L1TriggerTable.fL1TriggerTableName",
         "fL2TriggerTableName"               => "L2TriggerTable.fL2TriggerTableName",
         "fL3TriggerTableName"               => "L3TriggerTable.fL3TriggerTableName",
         "fHvSettingsName"                   => "HvSettings.fHvSettingsName",
         "fManuallyChangedName"              => "ManuallyChanged.fManuallyChangedName",
         "fObservationModeName"              => "ObservationMode.fObservationModeName",
         "fSumTriggerFlagName"               => "SumTriggerFlag.fSumTriggerFlagName",
         "fTriggerDelayTableName"            => "TriggerDelayTable.fTriggerDelayTableName",
         "fDiscriminatorThresholdTableName"  => "DiscriminatorThresholdTable.fDiscriminatorThesholdTableName",
         "fCalibrationScriptName"            => "CalibrationScript.fCalibrationScriptName",
         "fTestFlagName"                     => "TestFlag.fTestFlagName",
         "fLightConditionsName"              => "LightConditions.fLightConditionsName",
         "fRawFileAvail"                     => "RunProcessStatus.fRawFileAvail",
         "fCCFileAvail"                      => "RunProcessStatus.fCCFileAvail",
         "fCaCoFileAvail"                    => "RunProcessStatus.fCaCoFileAvail",
         "fCaCoFileFound"                    => "RunProcessStatus.fCaCoFileFound",
         "fTimingCorrection"                 => "RunProcessStatus.fTimingCorrection",
//         "fFillDotRaw"                       => "RunProcessStatus.fFillDotRaw",
         "fSequenceFileWritten"              => "SequenceProcessStatus.fSequenceFileWritten",
         "fAllFilesAvail"                    => "SequenceProcessStatus.fAllFilesAvail",
         "fCallisto"                         => "SequenceProcessStatus.fCallisto",
         "fFillCallisto"                     => "SequenceProcessStatus.fFillCallisto",
         "fStar"                             => "SequenceProcessStatus.fStar",
         "fFillStar"                         => "SequenceProcessStatus.fFillStar",
         "fUnsuitableInner"                  => "Calibration.fUnsuitableInner",
         "fUnsuitableOuter"                  => "Calibration.fUnsuitableOuter",
         "fUnsuitable50"                     => "Calibration.fUnsuitable50",
         "fUnsuitable01"                     => "Calibration.fUnsuitable01",
         "fUnsuitableMax"                    => "Calibration.fUnsuitableMax",
         "fDeadMax"                          => "Calibration.fDeadMax",
         "fRateTrigEvts"                     => "Calibration.fRateTrigEvts",
         "fRateSumEvts"                      => "Calibration.fRateSumEvts",
         "fRatePedEvts"                      => "Calibration.fRatePedEvts",
         "fRatePedTrigEvts"                  => "Calibration.fRatePedTrigEvts",
         "fRateCalEvts"                      => "Calibration.fRateCalEvts",
         "fRateNullEvts"                     => "Calibration.fRateNullEvts",
         "fRateUnknownEvts"                  => "Calibration.fRateUnknownEvts",
         "fRatioCalEvents"                   => "Calibration.fRatioCalEvents",
         "fPulsePosCalib"                    => "Calibration.fPulsePosCalib",
         "fUnreliableInner"                  => "Calibration.fUnreliableInner",
         "fUnreliableOuter"                  => "Calibration.fUnreliableOuter",
         "fIsolatedInner"                    => "Calibration.fIsolatedInner",
         "fIsolatedOuter"                    => "Calibration.fIsolatedOuter",
         "fIsolatedMaxCluster"               => "Calibration.fIsolatedMaxCluster",
         "fLastUpdate"                       => "Calibration.fLastUpdate",
         "fMeanPedRmsInner"                  => "Calibration.fMeanPedRmsInner",
         "fMeanPedRmsOuter"                  => "Calibration.fMeanPedRmsOuter",
         "fArrTimeMeanInner"                 => "Calibration.fArrTimeMeanInner",
         "fArrTimeMeanOuter"                 => "Calibration.fArrTimeMeanOuter",
         "fArrTimeRmsInner"                  => "Calibration.fArrTimeRmsInner",
         "fArrTimeRmsOuter"                  => "Calibration.fArrTimeRmsOuter",
         "fMeanSignalInner"                  => "Calibration.fMeanSignalInner",
         "fMeanSignalOuter"                  => "Calibration.fMeanSignalOuter",
         "fPulsePosMean"                     => "Calibration.fPulsePosMean",
         "fConvFactorInner"                  => "Calibration.fConvFactorInner",
         "fConvFactorOuter"                  => "Calibration.fConvFactorOuter",
         "fMeanNumberIslands"                => "Star.fMeanNumberIslands",
         "fPSF"                              => "Star.fPSF",
         "fRatio"                            => "Star.fRatio",
         "fMuonNumber"                       => "Star.fMuonNumber",
         "fEffOnTime"                        => "fEffOnTime",
         "fEffOnTime/fRunTime"               => "Sequences.fRunTime/Star.fEffOnTime",
         "fEffOnTime/3600"                   => "fEffOnTime/3600",
//         "fEffOnTime"                        => $fromtable . ".fEffOnTime",
         "fMuonRate"                         => "Star.fMuonRate",
         "fInhomogeneity"                    => "Star.fInhomogeneity",
         "fDataRate"                         => "Star.fDataRate",
         "fSparkRate"                        => "Star.fSparkRate",
         "fMaxHumidity"                      => "Star.fMaxHumidity",
         "fBrightnessMed"                    => "Star.fBrightnessMed",
         "fBrightnessRMS"                    => "Star.fBrightnessRMS",
         "fNumStarsMed"                      => "Star.fNumStarsMed",
         "fNumStarsRMS"                      => "Star.fNumStarsRMS",
         "fNumStarsCorMed"                   => "Star.fNumStarsCorMed",
         "fNumStarsCorRMS"                   => "Star.fNumStarsCorRMS",
         "fAvgWindSpeed"                     => "Star.fAvgWindSpeed",
         "fAvgTemperature"                   => "Star.fAvgTemperature",
         "fAvgHumidity"                      => "Star.fAvgHumidity",
         "fAvgTempSky"                       => "Star.fAvgTempSky",
         "fAvgCloudiness"                    => "Star.fAvgCloudiness",
         "fRmsCloudiness"                    => "Star.fRmsCloudiness",
         "fDataSetNumber"                    => $fromtable . ".fDataSetNumber",
         "fDataSetInserted"                  => "DataSetProcessStatus.fDataSetInserted",
         "fDataSetFileWritten"               => "DataSetProcessStatus.fDataSetFileWritten",
         "fStarFilesAvail"                   => "DataSetProcessStatus.fStarFilesAvail",
         "fGanymed"                          => "DataSetProcessStatus.fGanymed",
         "fFillGanymed"                      => "DataSetProcessStatus.fFillGanymed",
         "fComment"                          => "DataSets.fComment",
         "fDataSetName"                      => "DataSets.fDataSetName",
         "fEvents"                           => "DataCheck.fEvents",
         "fPositionSignal"                   => "DataCheck.fPositionSignal",
         "fPositionFWHM"                     => "DataCheck.fPositionFWHM",
         "fHeightSignal"                     => "DataCheck.fHeightSignal",
         "fHeightFWHM"                       => "DataCheck.fHeightFWHM",
         "fHasSignal"                        => "DataCheck.fHasSignal",
         "fHasPedestal"                      => "DataCheck.fHasPedestal",
         "fPositionAsym"                     => "DataCheck.fPositionAsym",
         "fHeightAsym"                       => "DataCheck.fHeightAsym",
         "fEventsInterlaced"                 => "DataCheck.fEventsInterlaced",
         "fPositionSignalInterlaced"         => "DataCheck.fPositionSignalInterlaced",
         "fPositionFWHMInterlaced"           => "DataCheck.fPositionFWHMInterlaced",
         "fHeightSignalInterlaced"           => "DataCheck.fHeightSignalInterlaced",
         "fHeightFWHMInterlaced"             => "DataCheck.fHeightFWHMInterlaced",
         "fHasSignalInterlaced"              => "DataCheck.fHasSignalInterlaced",
         "fHasPedestalInterlaced"            => "DataCheck.fHasPedestalInterlaced",
         "fPositionAsymInterlaced"           => "DataCheck.fPositionAsymInterlaced",
         "fHeightAsymInterlaced"             => "DataCheck.fHeightAsymInterlaced",
         "fExcessEvents"                     => "Ganymed.fExcessEvents",
         "fBackgroundEvents"                 => "Ganymed.fBackgroundEvents",
         "fSignalEvents"                     => "Ganymed.fSignalEvents",
         "fSignificance"                     => "Ganymed.fSignificance",
         "fScaleFactor"                      => "Ganymed.fScaleFactor",
         "fExcessEvents*60/fEffOnTime"       => "fExcessEvents*60/fEffOnTime",
         "fBackgroundEvents*60/fEffOnTime"   => "fBackgroundEvents*60/fEffOnTime",
         "fSignalEvents*60/fEffOnTime"       => "fSignalEvents*60/fEffOnTime",
         "Round(fSignificance/Sqrt(fEffOnTime/3600),2)" => "Round(fSignificance/Sqrt(fEffOnTime/3600),2)",
         "SUM(fRunTime)/3600"                => "'Time [h]'",
         "SUM(fNumEvents)"                   => "'Evts'",
         "Min(fZenithDistanceMin)"           => "'ZDMin'",
         "Max(fZenithDistanceMax)"           => "'ZDMax'",
         "Min(fZenithDistance)"              => "'ZdMin'",
         "Max(fZenithDistance)"              => "'ZdMax'",
//         "COUNT(*)"                          => "'Sequence'",
         "fStartTime"                        => "fStartTime",
         "fFailedTime"                       => "fFailedTime",
         "fReturnCode"                       => "fReturnCode",
         "fProgramId"                        => "fProgramId",
         "fParticleTypeName"                 => "ParticleType.fParticleTypeName",
         "fFitsFileName"                     => "FitsFile.fFitsFileName",
         "fObjectName"                       => "Object.fObjectName",
         "fStatusName"                       => "Status.fStatusName",
         "fBandName"                         => "Band.fBandName",
         "fTelescopeName"                    => "Telescope.fTelescopeName",
         "fUserName"                         => "User.fUserName",
         "fCycleName"                        => "Cycle.fCycleName",
         "fPIName"                           => "PI.fPIName",
         "fWorkingGroupName"                 => "WorkingGroup.fWorkingGroupName",
         "fProposalName"                     => "Proposal.fProposalName",
         "fWheelPos1"                        => "RunData.fWheelPos1",
         "fWheelPos2"                        => "RunData.fWheelPos2",
        );

    $table="";
    if (!empty($tables[$val]))
        $table=$tables[$val];
    if ($val=="Tel:Run/File")
        $table="'Tel:Run/File'";
    if ($val=="Tel:Sequ")
        $table="CONCAT('M', Sequences.fTelescopeNumber, ':', LPAD(Sequences.fSequenceFirst, 8, '0'))";
    if ($val=="NumRuns")
        $table="'# Runs'";
    if ($val=="NumSequ")
        $table="'# Sequ'";
    if ($val=="NumDS")
        $table="'# Datasets'";
    if ($val=="NumDays")
        $table="'# days'";
    if (empty($table))
        $table=$val;
    return $table;
}


function GetJoin($fromtable, $val)
{
    $joins = array
        (
         "fRunTypeName"                     => " LEFT JOIN RunType                     USING(fRunTypeKEY) ",
         "fProjectName"                     => " LEFT JOIN Project                     USING(fProjectKEY) ",
         "fSourceName"                      => " LEFT JOIN Source                      USING(fSourceKEY) ",
         "fMagicNumberName"                 => " LEFT JOIN MagicNumber                 USING(fMagicNumberKEY) ",
         "fL1TriggerTableName"              => " LEFT JOIN L1TriggerTable              USING(fL1TriggerTableKEY) ",
         "fL2TriggerTableName"              => " LEFT JOIN L2TriggerTable              USING(fL2TriggerTableKEY) ",
         "fL3TriggerTableName"              => " LEFT JOIN L3TriggerTable              USING(fL3TriggerTableKEY) ",
         "fHvSettingsName"                  => " LEFT JOIN HvSettings                  USING(fHvSettingsKEY) ",
         "fCalibrationScriptName"           => " LEFT JOIN CalibrationScript           USING(fCalibrationScriptKEY) ",
         "fExcludedFDAName"                 => " LEFT JOIN ExcludedFDA                 USING(fExcludedFDAKEY) ",
         "fManuallyChangedName"             => " LEFT JOIN ManuallyChanged             USING(fManuallyChangedKEY) ",
         "fObservationModeName"             => " LEFT JOIN ObservationMode             USING(fObservationModeKEY) ",
         "fSumTriggerFlagName"              => " LEFT JOIN SumTriggerFlag              USING(fSumTriggerFlagKEY) ",
         "fDiscriminatorThresholdTableName" => " LEFT JOIN DiscriminatorThresholdTable USING(fDiscriminatorThresholdTableKEY) ",
         "fTriggerDelayTableName"           => " LEFT JOIN TriggerDelayTable           USING(fTriggerDelayTableKEY) ",
         "fTestFlagName"                    => " LEFT JOIN TestFlag                    USING(fTestFlagKEY) ",
         "fLightConditionsName"             => " LEFT JOIN LightConditions             USING(fLightConditionsKEY) ",
         "fParticleTypeName"                => " LEFT JOIN ParticleType                USING(fParticleTypeKEY) ",
         "fFitsFileName"                    => " LEFT JOIN FitsFile                    USING(fFitsFileKEY) ",
         "fObjectName"                      => " LEFT JOIN Object                      USING(fObjectKEY) ",
         "fStatusName"                      => " LEFT JOIN Status                      USING(fStatusKEY) ",
         "fBandName"                        => " LEFT JOIN Band                        USING(fBandKEY) ",
         "fUserName"                        => " LEFT JOIN User                        USING(fUserKEY) ",
         "fTelescopeName"                   => " LEFT JOIN Telescope                   USING(fTelescopeKEY) ",
         "fCycleName"                       => " LEFT JOIN Cycle                       USING(fCycleKEY) ",
         "fPIName"                          => " LEFT JOIN PI                          USING(fPIKEY) ",
         "fWorkingGroupName"                => " LEFT JOIN WorkingGroup                USING(fWorkingGroupKEY) ",
         "fProposalName"                    => " LEFT JOIN Proposal                    USING(fProposalKEY) ",
        );


    $join="";
    if (!empty($joins[$val]))
        $join=$joins[$val];
    return $join;
}


?>
