#include "SlaPlanets.h"

#include <iostream>

#include "slalib.h"

ClassImp(SlaPlanets);

using namespace std;

SlaPlanets::SlaPlanets(MObservatory::LocationName_t key) : SlaStars(key), fDt(slaDt(2000.0)/60./60./24.)
{
}

void SlaPlanets::SetMjd(double mjd)
{
    SlaStars::SetMjd(mjd);

    fTt = GetMjd() + slaDtt(GetMjd())/60./60./24.;

    //
    // coordinates of earth: heliocentric, equatoril, J2000
    //
    double veb[3]; // barycentric velocity
    double ceb[3]; // barycentric coordinates
    double veh[3]; // heliocentric velocity

    slaEvp(GetMjd() + fDt, 2000.0, veb, ceb, veh, fEarth);
}

// --------------------------------------------------------------------------
//
// coordinates of planet: topocentric, equatorial, J2000
//
RaDec SlaPlanets::CalcPlanetRaDec(ePlanets_t planet)
{
    // coordinates of planet: topocentric, equatorial, J2000
    double ra, dec, diam;

    // One can use TT instead of TDB for all planets (except the moon?)
    // TDB, planet, elong, phi, *ra, *dec, *diam
    slaRdplan(fTt, planet, GetElong(), GetPhi(), &ra, &dec, &diam);

    return RaDec(ra, dec);
}

void SlaPlanets::UpdatePlanetPos(ePlanets_t planet)
{
    // coordinates of planet: topocentric, equatorial, J2000
    const RaDec rd = CalcPlanetRaDec(planet);

    double az, el;
    slaDe2h(GetAlpha()-rd.Ra(), rd.Dec(), GetPhi(), &az, &el);

    fZdAz[planet].Set(TMath::Pi()/2-el, az);
}

