#ifndef MHSTARMAP_H
#define MHSTARMAP_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MH_H
#include "MH.h"
#endif

#ifndef ROOT_TH2
// what's the reason that we need this here? cint complains about it
// if it is missing...
#include <TH2.h>
#endif

class MHillas;

class MHStarMap : public MH
{
private:
    TH2F *fStarMap;

    void PrepareDrawing();

public:
     MHStarMap(const char *name=NULL, const char *title=NULL);
    ~MHStarMap();

    void Fill(const MParContainer *par);

    TH2F *GetHist() { return fStarMap; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL);

    ClassDef(MHStarMap, 1) // Container to hold 2-dim histogram (starmap)
};

#endif

