///////////////////////////////////////////////////////////////////////
//
// MHHillas
//
// This class contains histograms for every Hillas parameter
//
///////////////////////////////////////////////////////////////////////

#include "MHHillas.h"

#include <math.h>

#include <TH1.h>
#include <TPad.h>
#include <TCanvas.h>

#include "MHillas.h"

ClassImp(MHHillas);

// --------------------------------------------------------------------------
//
// Setup four histograms for Alpha, Width, Length and Dist
//
MHHillas::MHHillas (const char *name, const char *title)
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    //
    //   set the name and title of this object
    //
    
    *fName  = name  ? name  : "MHHillas" ;
    *fTitle = title ? title : "Container for Hillas histograms" ;

    //
    // loop over all Pixels and create two histograms
    // one for the Low and one for the High gain
    // connect all the histogram with the container fHist
    //
    // FIXME! Make the histograms looking that they can be used for
    //        presentations (axis title, ...)
    //
    fAlpha  = new TH1F("Alpha [deg]", "Alpha of Hillas",   90, 0,  90);
    fWidth  = new TH1F("Width [mm]",  "Width of Hillas",  100, 0, 300);
    fLength = new TH1F("Length [mm]", "Length of Hillas", 100, 0, 300);
    fDist   = new TH1F("Dist [mm]",   "Dist of Hillas",   100, 0, 300);

    fAlpha->GetXaxis()->SetTitle("Alpha [deg]");
    fLength->GetXaxis()->SetTitle("Length [mm]");
    fDist->GetXaxis()->SetTitle("Dist [mm]");
    fWidth->GetXaxis()->SetTitle("Width [mm]");

    fAlpha->GetYaxis()->SetTitle("Counts");
    fLength->GetYaxis()->SetTitle("Counts");
    fDist->GetYaxis()->SetTitle("Counts");
    fWidth->GetYaxis()->SetTitle("Counts");
}

// --------------------------------------------------------------------------
//
// Delete the four histograms
//
MHHillas::~MHHillas()
{
    delete fAlpha;
    delete fWidth;
    delete fLength;
    delete fDist;
}

// --------------------------------------------------------------------------
//
// Fill the four histograms with data from a MHillas-Container.
// Be careful: Only call this with an object of type MHillas
//
void MHHillas::Fill(const MParContainer *par)
{
    MHillas &h = *(MHillas*)par;

    fAlpha ->Fill(fabs(h.GetAlpha()));
    fWidth ->Fill(h.GetWidth());
    fLength->Fill(h.GetLength());
    fDist  ->Fill(h.GetDist());
}

// --------------------------------------------------------------------------
//
// Draw clones of all four histograms. So that the object can be deleted
// and the histograms are still visible in the canvas.
// The cloned object are deleted together with the canvas if the canvas is
// destroyed. If you want to handle dostroying the canvas you can get a
// pointer to it from this function
//
TObject *MHHillas::DrawClone(Option_t *opt)
{
    TCanvas *c = new TCanvas("Hillas", "Histograms of Hillas Parameters");
    c->Divide(2,2);

    //
    // This is necessary to get the expected bahviour of DrawClone
    //
    gROOT->SetSelectedPad(NULL);

    c->cd(1);
    fAlpha->DrawClone()->SetBit(kCanDelete);

    c->cd(2);
    fLength->DrawClone()->SetBit(kCanDelete);

    c->cd(3);
    fDist->DrawClone()->SetBit(kCanDelete);

    c->cd(4);
    fWidth->DrawClone()->SetBit(kCanDelete);

    c->Modified();
    c->Update();

    return c;
}

// --------------------------------------------------------------------------
//
// Creates a new canvas and draws the four histograms into it.
// Be careful: The histograms belongs to this object and won't get deleted
// together with the canvas.
//
void MHHillas::Draw(Option_t *)
{

    //
    // Fixme! Check for an existing canvas.
    // And create one if no canvas exists only!
    //
    TCanvas *c = new TCanvas("Hillas", "Histograms of Hillas Parameters");
    c->Divide(2,2);

    c->cd(1);
    //fAlpha->SetBit(kCanDelete);
    fAlpha->Draw();

    c->cd(2);
    //fLength->SetBit(kCanDelete);
    fLength->Draw();

    c->cd(3);
    //fDist->SetBit(kCanDelete);
    fDist->Draw();

    c->cd(4);
    //fWidth->SetBit(kCanDelete);
    fWidth->Draw();

    c->Modified();
    c->Update();
}
