#ifndef COSY_MMoonPointing
#define COSY_MMoonPointing

#ifndef ROOT_TGraph2D
#include <TGraph2D.h>
#endif

#ifndef MARS_MPointing
#include "MPointing.h"
#endif

class MMoonPointing : public TObject
{
    TGraph2D fCos;
    TGraph2D fSin;

    Double_t fOffsetShadow; // [deg] distance of the Moon shadow from the Moon
    Double_t fOffsetWobble; // [deg] wobble offset

public:
    MMoonPointing(const char *filename);

    void SetOffsetShadow(Double_t off=-1) { fOffsetShadow=off; }
    void SetOffsetWobble(Double_t off=-1) { fOffsetWobble=off; }

    Bool_t CalcPosition(const ZdAz &moon, ZdAz &srcpos, ZdAz &pointpos) const;

    ClassDef(MMoonPointing, 0)
};

#endif
