/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MDumpEvtHeader.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"
#include "MRawEvtHeader.h"
#include "MRawEvtPixelIter.h"

ClassImp(MDumpEvtHeader)

Bool_t MDumpEvtHeader::PreProcess (MParList *pList)
{
    fRawEvtHeader = (MRawEvtHeader*)pList->FindObject("MRawEvtHeader");
    if (!fRawEvtHeader)
    {
        *fLog << dbginf << " Error: MRawEvtHeader not found... exit." << endl;
        return kFALSE;
    }

    fRawEvtData = (MRawEvtData*)pList->FindObject("MRawEvtData");
    if (!fRawEvtData)
    {
        *fLog << dbginf << " Error: MRawEvtData not found... exit." << endl;
        return kFALSE;
    }

    return kTRUE ;
} 

Bool_t MDumpEvtHeader::Process()
{
  fRawEvtHeader->Print();

  MRawEvtPixelIter pixel(fRawEvtData);

  while (pixel.Next())
      *fLog << " " << pixel.GetPixelId();

  *fLog << endl;
  
  return kTRUE;
} 
