#ifndef MGFADCDISP_H
#define MGFADCDISP_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class MParList;
class MReadTree;
class MRawEvtData;

class TList;
class TCanvas;
class TGListBox;
class TGTextEntry;

class MGFadcDisp : public TGTransientFrame
{
private:
    //
    // GUI stuff
    //
    TList       *fList;

    TGTextEntry *fTxtEvtNr;
    TGListBox   *fPixelList;

    TCanvas     *fCanvas;

    void AddTopFramePart1(TGVerticalFrame *frame,
                          const char *filename,
                          const char *treename);
    void AddTopFramePart2(TGVerticalFrame *frame);
    void AddMidFrame(TGHorizontalFrame *frame);
    void AddLowFrame(TGHorizontalFrame *frame);

    void CreateGui(const char *filename, const char *treename);
    void SetupFileAccess(const char *filename, const char *treename);

    //
    // File Access stuff
    //
    MParList    *pList;
    MRawEvtData *fEvtData;
    MReadTree   *fReadTree;

    void ReadinEvent(UInt_t iEvt);
    void DisplayPix(UInt_t i);

public:

    MGFadcDisp(char *filename, char *treename,
               const TGWindow *p, const TGWindow *main, UInt_t w, UInt_t h);

    ~MGFadcDisp();

    void CloseWindow();

    void CreatePixelList(Int_t lastsel=-1);
    void UpdateEventCounter();

    virtual Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    ClassDef(MGFadcDisp, 0)
};

#endif


