<?php

$timelimits = array
    (
     "Corsika" => "60",
     "Ceres" => "1",
     "SequenceFile" => "1",
     "Callisto" => "1",
     "Star" => "1",
     );


$checkwhere = array
    (
     "fParticleTypeName"                 => CheckWhere("fParticleTypeKEY"),
     "fRunTypeName"                      => CheckWhere("fRunTypeKEY"),
     "fAtmosphericModelName"             => CheckWhere("fAtmosphericModelKEY"),
    );

$checkgroup = array
    (
     "fParticleTypeName"                 => CheckGroup("fParticleTypeKEY"),
     "fRunTypeName"                      => CheckGroup("fRunTypeKEY"),
     "fAtmosphericModelName"             => CheckGroup("fAtmosphericModelKEY"),
    );


$checkstatusgroup = array
    (
     "Corsika"      => CheckStatusGroup("Corsika"),
     "Ceres"        => CheckStatusGroup("Ceres"),
     "SequenceFile" => CheckStatusGroup("SequenceFile"),
     "Callisto"     => CheckStatusGroup("Callisto"),
     "Star"         => CheckStatusGroup("Star"),
    );



$alias = array
    (
     "Run.File"                 => "Run.File",
     "fNumEvents"               => "#Evts",
     "SUM(fNumEvents)"          => "Evts",
     "fParticleTypeName"        => "Particle",
     "fRunTypeName"             => "RunType",
     "fAtmosphericModelName"    => "Atm.Model",
     "fCorsikaInputCreated"     => "Input",
     "Corsika"                  => "Corsika",
     "Ceres"                    => "Ceres",
     "SequenceFile"             => "SequenceFile",
     "Callisto"                 => "Callisto",
     "Star"                     => "Star",
     "fStartTime"               => "Process",
     "fFailedTime"              => "Failed",
     "fReturnCode"              => "Ret<br>Code",
     "fProgramId"               => "Prgr<br>Id",
     "fZenithDistanceMin"       => "Zd<br>Min",
     "fZenithDistanceMax"       => "Zd<br>Max",
     "fAzimuthMin"              => "Az<br>Min",
     "fAzimuthMax"              => "Az<br>Max",
     "Min(fZenithDistanceMin)"  => "ZDMin",
     "Max(fZenithDistanceMax)"  => "ZDMax",
     "fEnergyMin"               => "EMin<br>[GeV]",
     "fEnergyMax"               => "EMax<br>[GeV]",
     "fImpactMax"               => "Impact<br>[cm]",
     "fViewConeMax"             => "View<br>cone<br>[deg]",
     "fEnergySlope"             => "Slope",
     "fStartingAltitude"        => "Altitude<br>[g/sqcm]",
     "fMirrorDiameter"          => "Mirror<br>diam.<br>[cm]",
    );


$rightalign = array
    (
//     $alias["fRunNumber"]                => "1",
     $alias["fNumEvents"]                => "1",
     $alias["fZenithDistanceMin"]        => "1",
     $alias["fZenithDistanceMax"]        => "1",
     $alias["fAzimuthMin"]               => "1",
     $alias["fAzimuthMax"]               => "1",
     $alias["fEnergyMin"]                => "1",
     $alias["fEnergyMax"]                => "1",
     $alias["fImpactMax"]                => "1",
     $alias["fViewConeMax"]              => "1",
     $alias["fEnergySlope"]              => "1",
     $alias["fStartingAltitude"]         => "1",
     $alias["fMirrorDiameter"]           => "1",
     "Time"                              => "1",
     "Runs"                              => "1",
     "Evts"                              => "1",
);

function GetCheck($fromtable, $val)
{
    $checks = array
        (
         "fParticleTypeName"         => "ParticleType.fParticleTypeKEY",
         "fRunTypeName"              => "RunType.fRunTypeKEY",
         "fAtmosphericModelName"     => "AtmosphericModel.fAtmosphericModelKEY",
        );

    $check="";
    if (!empty($checks[$val]))
        $check=$checks[$val];
    return $check;
}


function GetTable($fromtable, $val)
{
    $tables = array
        (
         "fNumEvents"                        => $fromtable . ".fNumEvents",
         "fMCRunNumber"                      => "MCCorsikaRunData.fMCRunNumber",
         "fRawFileAvail"                     => "RunProcessStatus.fRawFileAvail",
         "SUM(fRunTime)/3600"                => "'Time [h]'",
         "SUM(fNumEvents)"                   => "'Evts'",
         "fStartTime"                        => "fStartTime",
         "fFailedTime"                       => "fFailedTime",
         "fReturnCode"                       => "fReturnCode",
         "fProgramId"                        => "fProgramId",
         "fParticleTypeName"                 => "ParticleType.fParticleTypeName",
         "fRunTypeName"                      => "RunType.fRunTypeName",
         "fAtmosphericModelName"             => "AtmosphericModel.fAtmosphericModelName",
         "fAzimuthMin"                       => "CorsikaInfo.fAzimuthMin",
         "fAzimuthMax"                       => "CorsikaInfo.fAzimuthMax",
         "fZenithDistanceMin"                => "CorsikaInfo.fZenithDistanceMin",
         "fZenithDistanceMax"                => "CorsikaInfo.fZenithDistanceMax",
         "fEnergyMin"                        => "CorsikaInfo.fEnergyMin",
         "fEnergyMax"                        => "CorsikaInfo.fEnergyMax",
         "fImpactMax"                        => "CorsikaInfo.fImpactMax",
         "fViewConeMax"                      => "CorsikaInfo.fViewConeMax",
         "fEnergySlope"                      => "CorsikaInfo.fEnergySlope",
         "fStartingAltitude"                 => "CorsikaInfo.fStartingAltitude",
         "fMirrorDiameter"                   => "CorsikaInfo.fMirrorDiameter",
         "Min(fZenithDistanceMin)"           => "'ZDMin'",
         "Max(fZenithDistanceMax)"           => "'ZDMax'",
        );

    $table="";
    if (!empty($tables[$val]))
        $table=$tables[$val];
    if ($val=="Run.File")
        $table="'Run.File'";
    if ($val=="Tel:Sequ")
        $table="CONCAT('M', Sequences.fTelescopeNumber, ':', LPAD(Sequences.fSequenceFirst, 8, '0'))";
    if ($val=="NumRuns")
        $table="'# Runs'";
    if ($val=="NumSequ")
        $table="'# Sequ'";
    if ($val=="NumDS")
        $table="'# Datasets'";
    if ($val=="# Files")
        $table="'# Files'";
    if ($val=="NumDays")
        $table="'# days'";
    if (empty($table))
        $table=$val;
    return $table;
}


function GetJoin($fromtable, $val)
{
    $joins = array
        (
         "fParticleTypeName"           => " LEFT JOIN ParticleType         USING(fParticleTypeKEY) ",
         "fRunTypeName"                => " LEFT JOIN RunType              USING(fRunTypeKEY) ",
         "fAtmosphericModelName"       => " LEFT JOIN AtmosphericModel     USING(fAtmosphericModelKEY) ",
         "Corsika"                     => " LEFT JOIN CorsikaStatus        USING(fRunNumber, fFileNumber) ",
         "Ceres"                       => " LEFT JOIN CeresStatus          USING(fRunNumber, fFileNumber, fCeresSetupKEY) ",
         "SequenceFile"                => " LEFT JOIN SequenceFileStatus   USING(fSequenceNumber) ",
         "Callisto"                    => " LEFT JOIN CallistoStatus       USING(fSequenceNumber, fCeresSetupKEY) ",
         "Star"                        => " LEFT JOIN StarStatus           USING(fSequenceNumber, fCeresSetupKEY) ",
        );


    $join="";
    if (!empty($joins[$val]))
        $join=$joins[$val];
    return $join;
}


?>
