#ifndef MFILLH_H
#define MFILLH_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MTASK_H
#include "MTask.h"
#endif

class MH;
class MParList;

class MFillH : public MTask
{
private:
    const MParContainer *fParContainer;
    TString fParContainerName;

    MH* fH;
    TString fHName;

    void Init(const char *name, const char *title);

public:
    MFillH(const char *par,          const char *hist, const char *name=NULL, const char *title=NULL);
    MFillH(const MParContainer *par, const char *hist, const char *name=NULL, const char *title=NULL);
    MFillH(const char *par,          MH *hist,         const char *name=NULL, const char *title=NULL);
    MFillH(const MParContainer *par, MH *hist,         const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MFillH, 0) // Task to fill a histogram with data from a parameter container
};
    
#endif

