----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
-- 
-- Create Date:    08/04/2010 
-- Design Name: 
-- Module Name:    FTU_test8_dac_control - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    test8 for controling DAC on FTU board 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
library ftu_definitions_test8;
USE ftu_definitions_test8.ftu_array_types.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTU_test8_dac_control is
  port(
    clk      : IN     STD_LOGIC;
    reset    : IN     STD_LOGIC;
    clr      : OUT    STD_LOGIC;
    mosi     : OUT    STD_LOGIC;
    sck      : OUT    STD_LOGIC;
    cs_ld    : out    STD_LOGIC;
    enable1  : out    STD_LOGIC;
    enable2  : out    STD_LOGIC;
    enable3  : out    STD_LOGIC
  );
end FTU_test8_dac_control;

architecture Behavioral of FTU_test8_dac_control is

  component FTU_test8_spi_interface
    port(
      clk_50MHz      : IN     std_logic;
      config_start   : IN     std_logic;
      dac_array      : IN     dac_array_type;
      config_ready   : OUT    std_logic;
      config_started : OUT    std_logic;
      dac_cs         : OUT    std_logic;
      mosi           : OUT    std_logic;
      sclk           : OUT    std_logic;
      miso           : INOUT  std_logic
   );
  end component;

  signal clk_sig            : std_logic;
  signal reset_sig          : std_logic;

  signal clr_sig            : std_logic;
  signal mosi_sig           : std_logic := '0';
  signal serial_clock_sig   : std_logic;
  signal dac_cs_sig         : std_logic;
  
  signal config_start_sig   : std_logic := '0';  
  signal config_ready_sig   : std_logic;
  signal config_started_sig : std_logic := '0';
  signal dac_array_sig      : dac_array_type := (0,0,0,0,0,0,0,100);
 
  -- Build an enumerated type for the state machine
  type state_type is (START, SET, WAITING, WAITING_MORE, STOP);

  -- Register to hold the current state
  signal state : state_type;

  signal ramp_cnt    : integer range 0 to 45 := 0;
  constant RAMP_STEP : integer := 91;

  --signal wait_cnt : integer range 0 to 150000000 := 0; --implement
  signal wait_cnt : integer range 0 to 10 := 0; --simulation
  --change this also below!!!
  
begin

  reset_sig <= reset;
  clk_sig <= clk;
  mosi <= mosi_sig;
  sck <= serial_clock_sig;
  cs_ld <= dac_cs_sig;
  
  -- FSM for dac control: second process
  FSM_logic: process(clk_sig)
  begin
    if rising_edge(clk_sig) then
    case state is
      when START =>
        dac_array_sig <= (0,0,0,0,0,0,0,100);
        config_start_sig <= '0';
        enable1 <= '0';
        enable2 <= '1';
        enable3 <= '1';
        state <= SET;  
      when SET =>
        dac_array_sig <= (ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,0,0,0,100);
        config_start_sig <= '1';
        enable1 <= '0';
        enable2 <= '1';
        enable3 <= '1';
        if config_started_sig = '1' then
          state <= WAITING;
        else
          state <= SET;
        end if;
      when WAITING =>
        dac_array_sig <= (ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,0,0,0,100);
        config_start_sig <= '1';
        enable1 <= '0';
        enable2 <= '1';
        enable3 <= '1';
        if (config_ready_sig = '1') then          
          state <= WAITING_MORE;          
        else
          state <= WAITING;
        end if;
      when WAITING_MORE =>
        dac_array_sig <= (ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,ramp_cnt*91,0,0,0,100);
        config_start_sig <= '0';
        enable1 <= '1';
        enable2 <= '0';
        enable3 <= '1';
        if wait_cnt < 10 then
          wait_cnt <= wait_cnt + 1;
          state <= WAITING_MORE;
        else
          wait_cnt <= 0;
          if (ramp_cnt < 45) then
            ramp_cnt <= ramp_cnt + 1;
            state <= SET;
          else
            state <= STOP;
          end if;       
        end if;
      when STOP =>
        dac_array_sig <= (0,0,0,0,0,0,0,100);
        enable1 <= '1';
        enable2 <= '1';
        enable3 <= '0';
        config_start_sig <= '0';
    end case;
    end if;
  end process;
    
  Inst_FTU_test8_spi_interface : FTU_test8_spi_interface
    port map(
      clk_50MHz      => clk_sig,
      config_start   => config_start_sig,
      dac_array      => dac_array_sig,
      config_ready   => config_ready_sig,
      config_started => config_started_sig,
      dac_cs         => dac_cs_sig,
      mosi           => mosi_sig,
      sclk           => serial_clock_sig,
      miso           => open
    );

end Behavioral;

