#ifndef MARS_MCerPhotEvt
#define MARS_MCerPhotEvt

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif
#ifndef MARS_MCerPhotPix
#include "MCerPhotPix.h"
#endif

class MGeomCam;
class MCerPhotPix;

class MCerPhotEvt : public MParContainer
{
private:
    UInt_t        fNumPixels;
    TClonesArray *fPixels;     // FIXME: Change TClonesArray away from a pointer?

public:
    MCerPhotEvt(const char *name=NULL, const char *title=NULL);
    ~MCerPhotEvt() { delete fPixels; }

    UInt_t GetNumPixels() const { return fNumPixels; }
    void   InitSize(UInt_t num) { fPixels->Expand(num); }

    void   AddPixel(Int_t id, Float_t nph, Float_t er)
    {
        new ((*fPixels)[fNumPixels++]) MCerPhotPix(id, nph, er);
    }


    Bool_t  IsPixelExisting(Int_t id) const;
    Bool_t  IsPixelUsed    (Int_t id) const;
    Bool_t  IsPixelCore    (Int_t id) const;

    Float_t GetNumPhotonsMin(const MGeomCam *geom=NULL) const;
    Float_t GetNumPhotonsMax(const MGeomCam *geom=NULL) const;

    MCerPhotPix &operator[](int i)       { return *(MCerPhotPix*)(fPixels->UncheckedAt(i)); }
    MCerPhotPix &operator[](int i) const { return *(MCerPhotPix*)(fPixels->UncheckedAt(i)); }

    void Reset();

    void Draw(Option_t* option = "");
    void Print(Option_t *opt=NULL) const;
    void Clear(Option_t *opt=NULL) { Reset(); }

    ClassDef(MCerPhotEvt, 1)    // class for an event containing cerenkov photons
};

#endif

