#ifndef MARS_MFAlpha
#define MARS_MFAlpha

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFAlpha                                                                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MHillasSrc;

class MFAlpha : public MFilter
{
private:
    const MHillasSrc *fHillas;
    TString fContName;

    typedef enum { kELowerThan, kEGreaterThan } FilterType_t;
    FilterType_t fFilterType;

    Bool_t  fResult;
    Float_t fValue; // [deg]

    void Init(const char type, const Int_t val,
              const char *name, const char *title);

public:
    MFAlpha(const char       *cname="MHillas", const char type='>', const Float_t deg=15,
            const char *name=NULL, const char *title=NULL);
    MFAlpha(const MHillasSrc *hillas,          const char type='>', const Float_t deg=15,
            const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MFAlpha, 0) // A Filter for cuts in fabs(alpha)
};

#endif
