#ifndef MARS_MHGamma
#define MARS_MHGamma

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include "TH3.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class TH2D;
class TH3D;

class MHGamma : public MH 
{
public:
    MHGamma();

    Bool_t Fill(const MParContainer *par);

    TH3D *Subtract(const TH3D *h1, const TH3D *h2,
                   const char *name, const char *title, Bool_t Draw=kFALSE);

    TH2D *GetAlphaProjection(TH3D *fHist, Axis_t lo, Axis_t up, 
                             Bool_t Drawp=kFALSE);


    ClassDef(MHGamma, 1) // manipulation of alpha distributions
};

#endif






