#ifndef MARS_MReportTrigger
#define MARS_MReportTrigger

#ifndef MARS_MReport
#include "MReport.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class MReportTrigger : public MReport
{
private:
    Float_t fL2BeforePrescaler; // L2 trigger rate before prescaler
    Float_t fL2AfterPrescaler;  // L2 trigger rate before prescaler

    TArrayF fPrescalerRates;    //[Hz] L2 prescaler rates
    //TArrayF fRates;           //[Hz] curently undefined

public:
    MReportTrigger();

    Bool_t InterpreteBody(TString &str);

    ClassDef(MReportTrigger, 1) // Class for TRIGGER-REPORT information
};

#endif
