/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Markus Gaug   11/2003 <mailto:markus@ifae.es>
!
!   Copyright: MAGIC Software Development, 2000-2004
!
!
\* ======================================================================== */
/////////////////////////////////////////////////////////////////////////////
//                                                               
// MCalibrationIntensityTestCam                                               
//                                                               
// Storage container for intensity charge calibration results. 
// 
// Individual MCalibrationTestCam's can be retrieved with: 
// - GetCam() yielding the current cam.
// - GetCam("name") yielding the current camera with name "name".
// - GetCam(i) yielding the i-th camera.
//
// See also: MCalibrationIntensityCam, MCalibrationTestCam,
//           MCalibrationTestPix, MCalibrationTestCalc, MCalibrationQECam
//           MHCalibrationTestPix, MHCalibrationTestCam              
//
/////////////////////////////////////////////////////////////////////////////
#include "MCalibrationIntensityTestCam.h"
#include "MCalibrationTestCam.h"

#include <TOrdCollection.h>

ClassImp(MCalibrationIntensityTestCam);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor. 
//
MCalibrationIntensityTestCam::MCalibrationIntensityTestCam(const char *name, const char *title)
{

  fName  = name  ? name  : "MCalibrationIntensityTestCam";
  fTitle = title ? title : "Results of the Intensity Calibration";
  
  InitSize(1);
}

// -------------------------------------------------------------------
//
// Add MCalibrationTestCam's in the ranges from - to. 
//
void MCalibrationIntensityTestCam::Add(const UInt_t from, const UInt_t to)
{
  for (UInt_t i=from; i<to; i++)
    fCams->AddAt(new MCalibrationTestCam,i);
}

